/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.airlift.log.Logging;
import com.facebook.airlift.log.LoggingConfiguration;
import com.facebook.presto.cli.ClientOptions;
import com.facebook.presto.cli.Completion;
import com.facebook.presto.cli.Help;
import com.facebook.presto.cli.LineReader;
import com.facebook.presto.cli.Query;
import com.facebook.presto.cli.QueryPreprocessor;
import com.facebook.presto.cli.QueryPreprocessorException;
import com.facebook.presto.cli.QueryRunner;
import com.facebook.presto.cli.TableNameCompleter;
import com.facebook.presto.cli.ThreadInterruptor;
import com.facebook.presto.cli.VersionOption;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.sql.parser.StatementSplitter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.airline.Command;
import io.airlift.airline.HelpOption;
import io.airlift.units.Duration;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.inject.Inject;
import jline.console.history.FileHistory;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import jline.internal.Configuration;
import org.fusesource.jansi.AnsiConsole;

@Command(name="presto", description="Presto interactive console")
public class Console {
    private static final String PROMPT_NAME = "presto";
    private static final Duration EXIT_DELAY = new Duration(3.0, TimeUnit.SECONDS);
    private static final Pattern HISTORY_INDEX_PATTERN = Pattern.compile("!\\d+");
    @Inject
    public HelpOption helpOption;
    @Inject
    public VersionOption versionOption = new VersionOption();
    @Inject
    public ClientOptions clientOptions = new ClientOptions();

    /*
     * Loose catch block
     */
    public boolean run() {
        boolean isFromFile;
        ClientSession session = this.clientOptions.toClientSession();
        boolean hasQuery = !Strings.isNullOrEmpty((String)this.clientOptions.execute);
        boolean bl = isFromFile = !Strings.isNullOrEmpty((String)this.clientOptions.file);
        if (!hasQuery && !isFromFile) {
            AnsiConsole.systemInstall();
        }
        Console.initializeLogging(this.clientOptions.logLevelsFile);
        String query = this.clientOptions.execute;
        if (hasQuery) {
            query = query + ";";
        }
        if (isFromFile) {
            if (hasQuery) {
                throw new RuntimeException("both --execute and --file specified");
            }
            try {
                query = Files.asCharSource((File)new File(this.clientOptions.file), (Charset)StandardCharsets.UTF_8).read();
                hasQuery = true;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading from file %s: %s", this.clientOptions.file, e.getMessage()));
            }
        }
        AtomicBoolean exiting = new AtomicBoolean();
        ThreadInterruptor interruptor = new ThreadInterruptor();
        CountDownLatch exited = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            exiting.set(true);
            interruptor.interrupt();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)exited, (long)EXIT_DELAY.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        }));
        try {
            boolean bl2;
            try (QueryRunner queryRunner = new QueryRunner(session, this.clientOptions.debug, Optional.ofNullable(this.clientOptions.socksProxy), Optional.ofNullable(this.clientOptions.httpProxy), Optional.ofNullable(this.clientOptions.keystorePath), Optional.ofNullable(this.clientOptions.keystorePassword), Optional.ofNullable(this.clientOptions.truststorePath), Optional.ofNullable(this.clientOptions.truststorePassword), Optional.ofNullable(this.clientOptions.accessToken), Optional.ofNullable(this.clientOptions.user), this.clientOptions.password ? Optional.of(this.getPassword()) : Optional.empty(), Optional.ofNullable(this.clientOptions.krb5Principal), Optional.ofNullable(this.clientOptions.krb5RemoteServiceName), Optional.ofNullable(this.clientOptions.krb5ConfigPath), Optional.ofNullable(this.clientOptions.krb5KeytabPath), Optional.ofNullable(this.clientOptions.krb5CredentialCachePath), !this.clientOptions.krb5DisableRemoteServiceHostnameCanonicalization, !this.clientOptions.disableRedirects);){
                if (hasQuery) {
                    boolean bl3 = Console.executeCommand(queryRunner, query, this.clientOptions.outputFormat, this.clientOptions.ignoreErrors);
                    return bl3;
                }
                Console.runConsole(queryRunner, exiting);
                bl2 = true;
            }
            return bl2;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            exited.countDown();
            interruptor.close();
        }
    }

    private String getPassword() {
        Preconditions.checkState((this.clientOptions.user != null ? 1 : 0) != 0, (Object)"Username must be specified along with password");
        String defaultPassword = System.getenv("PRESTO_PASSWORD");
        if (defaultPassword != null) {
            return defaultPassword;
        }
        java.io.Console console = System.console();
        if (console == null) {
            throw new RuntimeException("No console from which to read password");
        }
        char[] password = console.readPassword("Password: ", new Object[0]);
        if (password != null) {
            return new String(password);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runConsole(QueryRunner queryRunner, AtomicBoolean exiting) {
        try (TableNameCompleter tableNameCompleter = new TableNameCompleter(queryRunner);
             LineReader reader = new LineReader((History)Console.getHistory(), Completion.commandCompleter(), Completion.lowerCaseCommandCompleter(), tableNameCompleter);){
            tableNameCompleter.populateCache();
            StringBuilder buffer = new StringBuilder();
            block43: while (!exiting.get()) {
                String prompt = PROMPT_NAME;
                String schema = queryRunner.getSession().getSchema();
                if (schema != null) {
                    prompt = prompt + ":" + schema;
                }
                if (buffer.length() > 0) {
                    prompt = Strings.repeat((String)" ", (int)(prompt.length() - 1)) + "-";
                }
                String commandPrompt = prompt + "> ";
                String line = reader.readLine(commandPrompt);
                if (reader.interrupted()) {
                    String partial = StatementSplitter.squeezeStatement((String)buffer.toString());
                    if (!partial.isEmpty()) {
                        reader.getHistory().add((CharSequence)partial);
                    }
                    buffer = new StringBuilder();
                    continue;
                }
                if (line == null) {
                    System.out.println();
                    return;
                }
                if (buffer.length() == 0) {
                    String command = line.trim();
                    if (HISTORY_INDEX_PATTERN.matcher(command).matches()) {
                        int historyIndex = Integer.parseInt(command.substring(1));
                        History history = reader.getHistory();
                        if (historyIndex <= 0 || historyIndex > history.index()) {
                            System.err.println("Command does not exist");
                            continue;
                        }
                        line = history.get(historyIndex - 1).toString();
                        System.out.println(commandPrompt + line);
                    }
                    if (command.endsWith(";")) {
                        command = command.substring(0, command.length() - 1).trim();
                    }
                    switch (command.toLowerCase(Locale.ENGLISH)) {
                        case "exit": 
                        case "quit": {
                            return;
                        }
                        case "history": {
                            Iterator iterator = reader.getHistory().iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block43;
                                History.Entry entry = (History.Entry)iterator.next();
                                System.out.printf("%5d  %s%n", entry.index() + 1, entry.value());
                            }
                        }
                        case "help": {
                            System.out.println();
                            System.out.println(Help.getHelpText());
                            continue block43;
                        }
                    }
                }
                buffer.append(line).append("\n");
                String sql = buffer.toString();
                StatementSplitter splitter = new StatementSplitter(sql, (Set)ImmutableSet.of((Object)";", (Object)"\\G"));
                for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
                    ClientOptions.OutputFormat outputFormat = ClientOptions.OutputFormat.ALIGNED;
                    if (split.terminator().equals("\\G")) {
                        outputFormat = ClientOptions.OutputFormat.VERTICAL;
                    }
                    Console.process(queryRunner, split.statement(), outputFormat, tableNameCompleter::populateCache, true);
                    reader.getHistory().add((CharSequence)(StatementSplitter.squeezeStatement((String)split.statement()) + split.terminator()));
                }
                buffer = new StringBuilder();
                String partial = splitter.getPartialStatement();
                if (partial.isEmpty()) continue;
                buffer.append(partial).append('\n');
            }
            return;
        }
        catch (IOException e) {
            System.err.println("Readline error: " + e.getMessage());
        }
    }

    @VisibleForTesting
    static boolean executeCommand(QueryRunner queryRunner, String query, ClientOptions.OutputFormat outputFormat, boolean ignoreErrors) {
        boolean success = true;
        StatementSplitter splitter = new StatementSplitter(query);
        for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
            if (StatementSplitter.isEmptyStatement((String)split.statement()) || Console.process(queryRunner, split.statement(), outputFormat, () -> {}, false)) continue;
            if (!ignoreErrors) {
                return false;
            }
            success = false;
        }
        if (!StatementSplitter.isEmptyStatement((String)splitter.getPartialStatement())) {
            System.err.println("Non-terminated statement: " + splitter.getPartialStatement());
            return false;
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean process(QueryRunner queryRunner, String sql, ClientOptions.OutputFormat outputFormat, Runnable schemaChanged, boolean interactive) {
        String finalSql;
        try {
            finalSql = QueryPreprocessor.preprocessQuery(Optional.ofNullable(queryRunner.getSession().getCatalog()), Optional.ofNullable(queryRunner.getSession().getSchema()), sql);
        }
        catch (QueryPreprocessorException e) {
            System.err.println(e.getMessage());
            if (!queryRunner.isDebug()) return false;
            e.printStackTrace();
            return false;
        }
        try (Query query = queryRunner.startQuery(finalSql);){
            boolean success = query.renderOutput(System.out, outputFormat, interactive);
            ClientSession session = queryRunner.getSession();
            if (query.getSetCatalog().isPresent() || query.getSetSchema().isPresent()) {
                session = ClientSession.builder((ClientSession)session).withCatalog(query.getSetCatalog().orElse(session.getCatalog())).withSchema(query.getSetSchema().orElse(session.getSchema())).build();
                schemaChanged.run();
            }
            if (query.isClearTransactionId()) {
                session = ClientSession.stripTransactionId((ClientSession)session);
            }
            ClientSession.Builder builder = ClientSession.builder((ClientSession)session);
            if (query.getStartedTransactionId() != null) {
                builder = builder.withTransactionId(query.getStartedTransactionId());
            }
            if (!query.getSetSessionProperties().isEmpty() || !query.getResetSessionProperties().isEmpty()) {
                HashMap<String, String> sessionProperties = new HashMap<String, String>(session.getProperties());
                sessionProperties.putAll(query.getSetSessionProperties());
                sessionProperties.keySet().removeAll(query.getResetSessionProperties());
                builder = builder.withProperties(sessionProperties);
            }
            if (!query.getSetRoles().isEmpty()) {
                HashMap<String, SelectedRole> roles = new HashMap<String, SelectedRole>(session.getRoles());
                roles.putAll(query.getSetRoles());
                builder = builder.withRoles(roles);
            }
            if (!query.getAddedPreparedStatements().isEmpty() || !query.getDeallocatedPreparedStatements().isEmpty()) {
                HashMap<String, String> preparedStatements = new HashMap<String, String>(session.getPreparedStatements());
                preparedStatements.putAll(query.getAddedPreparedStatements());
                preparedStatements.keySet().removeAll(query.getDeallocatedPreparedStatements());
                builder = builder.withPreparedStatements(preparedStatements);
            }
            if (!query.getAddedSessionFunctions().isEmpty() || !query.getRemovedSessionFunctions().isEmpty()) {
                HashMap<String, String> sessionFunctions = new HashMap<String, String>(session.getSessionFunctions());
                sessionFunctions.putAll(query.getAddedSessionFunctions());
                sessionFunctions.keySet().removeAll(query.getRemovedSessionFunctions());
                builder = builder.withSessionFunctions(sessionFunctions);
            }
            session = builder.build();
            queryRunner.setSession(session);
            boolean bl = success;
            return bl;
        }
        catch (RuntimeException e) {
            System.err.println("Error running command: " + e.getMessage());
            if (!queryRunner.isDebug()) return false;
            e.printStackTrace();
            return false;
        }
    }

    private static MemoryHistory getHistory() {
        String historyFilePath = System.getenv("PRESTO_HISTORY_FILE");
        File historyFile = Strings.isNullOrEmpty((String)historyFilePath) ? new File(Configuration.getUserHome(), ".presto_history") : new File(historyFilePath);
        return Console.getHistory(historyFile);
    }

    @VisibleForTesting
    static MemoryHistory getHistory(File historyFile) {
        FileHistory history;
        try {
            Files.createParentDirs((File)historyFile.getParentFile());
            historyFile.createNewFile();
            history = new FileHistory(historyFile);
            history.setMaxSize(10000);
        }
        catch (IOException e) {
            System.err.printf("WARNING: Failed to load history file (%s): %s. History will not be available during this session.%n", historyFile, e.getMessage());
            history = new MemoryHistory();
        }
        history.setAutoTrim(true);
        return history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeLogging(String logLevelsFile) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            LoggingConfiguration config = new LoggingConfiguration();
            if (logLevelsFile == null) {
                System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
                System.setErr(new PrintStream(ByteStreams.nullOutputStream()));
                config.setConsoleEnabled(false);
            } else {
                config.setLevelsFile(logLevelsFile);
            }
            Logging logging = Logging.initialize();
            logging.configure(config);
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
    }
}

