/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.ConsolePrinter;
import com.facebook.presto.cli.WarningsPrinter;
import com.facebook.presto.spi.PrestoWarning;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

abstract class AbstractWarningsPrinter
implements WarningsPrinter {
    private static final String WARNING_BEGIN = "\u001b[33m";
    private static final String WARNING_END = "\u001b[39m";
    private final OptionalInt maxWarnings;
    private boolean hasProcessedWarnings;
    private int processedWarnings;

    AbstractWarningsPrinter(OptionalInt maxWarnings) {
        this.maxWarnings = Objects.requireNonNull(maxWarnings, "maxWarnings is null");
    }

    private String getWarningMessage(PrestoWarning warning) {
        if (ConsolePrinter.REAL_TERMINAL) {
            return String.format("%sWARNING: %s%s", WARNING_BEGIN, warning.getMessage(), WARNING_END);
        }
        return String.format("WARNING: %s", warning.getMessage());
    }

    private List<String> getNewWarnings(List<PrestoWarning> warnings) {
        int end = warnings.size();
        if (this.maxWarnings.isPresent()) {
            end = Math.min(this.processedWarnings + this.maxWarnings.getAsInt(), end);
        }
        List subList = (List)warnings.subList(this.processedWarnings, end).stream().map(this::getWarningMessage).collect(ImmutableList.toImmutableList());
        this.processedWarnings = end;
        return subList;
    }

    protected abstract void print(List<String> var1);

    protected abstract void printSeparator();

    private void printWithSeparators(List<String> warnings) {
        if (!warnings.isEmpty()) {
            this.printSeparator();
            this.print(warnings);
            this.printSeparator();
        }
    }

    private void printWithInitialSeparator(List<String> warnings) {
        if (!this.hasProcessedWarnings && !warnings.isEmpty()) {
            this.printSeparator();
            this.hasProcessedWarnings = true;
            this.print(warnings);
        }
    }

    private void printWithTrailingSeparator(List<String> warnings) {
        if (!warnings.isEmpty()) {
            this.print(warnings);
            this.printSeparator();
        }
    }

    @Override
    public void print(List<PrestoWarning> warnings, boolean withInitialSeparator, boolean withTrailingSeparator) {
        Objects.requireNonNull(warnings, "warnings is null");
        List<String> newWarnings = this.getNewWarnings(warnings);
        if (withInitialSeparator) {
            if (withTrailingSeparator) {
                this.printWithSeparators(newWarnings);
            } else {
                this.printWithInitialSeparator(newWarnings);
            }
        } else if (withTrailingSeparator) {
            this.printWithTrailingSeparator(newWarnings);
        } else {
            this.print(newWarnings);
        }
    }
}

