/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.Query;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.OkHttpUtil;
import com.facebook.presto.client.StatementClient;
import com.facebook.presto.client.StatementClientFactory;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.io.Closeable;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import okhttp3.OkHttpClient;

public class QueryRunner
implements Closeable {
    private final AtomicReference<ClientSession> session;
    private final boolean debug;
    private final OkHttpClient httpClient;
    private final Consumer<OkHttpClient.Builder> sslSetup;

    public QueryRunner(ClientSession session, boolean debug, Optional<HostAndPort> socksProxy, Optional<HostAndPort> httpProxy, Optional<String> keystorePath, Optional<String> keystorePassword, Optional<String> truststorePath, Optional<String> truststorePassword, Optional<String> accessToken, Optional<String> user, Optional<String> password, Optional<String> kerberosPrincipal, Optional<String> kerberosRemoteServiceName, Optional<String> kerberosConfigPath, Optional<String> kerberosKeytabPath, Optional<String> kerberosCredentialCachePath, boolean kerberosUseCanonicalHostname) {
        this.session = new AtomicReference<ClientSession>(Objects.requireNonNull(session, "session is null"));
        this.debug = debug;
        this.sslSetup = builder -> OkHttpUtil.setupSsl((OkHttpClient.Builder)builder, (Optional)keystorePath, (Optional)keystorePassword, (Optional)truststorePath, (Optional)truststorePassword);
        OkHttpClient.Builder builder2 = new OkHttpClient.Builder();
        OkHttpUtil.setupTimeouts((OkHttpClient.Builder)builder2, (int)30, (TimeUnit)TimeUnit.SECONDS);
        OkHttpUtil.setupCookieJar((OkHttpClient.Builder)builder2);
        OkHttpUtil.setupSocksProxy((OkHttpClient.Builder)builder2, socksProxy);
        OkHttpUtil.setupHttpProxy((OkHttpClient.Builder)builder2, httpProxy);
        QueryRunner.setupBasicAuth(builder2, session, user, password);
        QueryRunner.setupTokenAuth(builder2, session, accessToken);
        if (kerberosRemoteServiceName.isPresent()) {
            Preconditions.checkArgument((boolean)session.getServer().getScheme().equalsIgnoreCase("https"), (Object)"Authentication using Kerberos requires HTTPS to be enabled");
            OkHttpUtil.setupKerberos((OkHttpClient.Builder)builder2, (String)kerberosRemoteServiceName.get(), (boolean)kerberosUseCanonicalHostname, kerberosPrincipal, kerberosConfigPath.map(File::new), kerberosKeytabPath.map(File::new), kerberosCredentialCachePath.map(File::new));
        }
        this.httpClient = builder2.build();
    }

    public ClientSession getSession() {
        return this.session.get();
    }

    public void setSession(ClientSession session) {
        this.session.set(Objects.requireNonNull(session, "session is null"));
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Query startQuery(String query) {
        return new Query(this.startInternalQuery(this.session.get(), query), this.debug);
    }

    public StatementClient startInternalQuery(String query) {
        return this.startInternalQuery(ClientSession.stripTransactionId((ClientSession)this.session.get()), query);
    }

    private StatementClient startInternalQuery(ClientSession session, String query) {
        OkHttpClient.Builder builder = this.httpClient.newBuilder();
        this.sslSetup.accept(builder);
        OkHttpClient client = builder.build();
        return StatementClientFactory.newStatementClient((OkHttpClient)client, (ClientSession)session, (String)query);
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    private static void setupBasicAuth(OkHttpClient.Builder clientBuilder, ClientSession session, Optional<String> user, Optional<String> password) {
        if (user.isPresent() && password.isPresent()) {
            Preconditions.checkArgument((boolean)session.getServer().getScheme().equalsIgnoreCase("https"), (Object)"Authentication using username/password requires HTTPS to be enabled");
            clientBuilder.addInterceptor(OkHttpUtil.basicAuth((String)user.get(), (String)password.get()));
        }
    }

    private static void setupTokenAuth(OkHttpClient.Builder clientBuilder, ClientSession session, Optional<String> accessToken) {
        if (accessToken.isPresent()) {
            Preconditions.checkArgument((boolean)session.getServer().getScheme().equalsIgnoreCase("https"), (Object)"Authentication using an access token requires HTTPS to be enabled");
            clientBuilder.addInterceptor(OkHttpUtil.tokenAuth((String)accessToken.get()));
        }
    }
}

