/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.Query;
import com.facebook.presto.client.ClientException;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.OkHttpUtil;
import com.facebook.presto.client.StatementClient;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.io.Closeable;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import okhttp3.OkHttpClient;

public class QueryRunner
implements Closeable {
    private final AtomicReference<ClientSession> session;
    private final OkHttpClient httpClient;
    private final Consumer<OkHttpClient.Builder> sslSetup;

    public QueryRunner(ClientSession session, Optional<HostAndPort> socksProxy, Optional<HostAndPort> httpProxy, Optional<String> keystorePath, Optional<String> keystorePassword, Optional<String> truststorePath, Optional<String> truststorePassword, Optional<String> user, Optional<String> password, Optional<String> kerberosPrincipal, Optional<String> kerberosRemoteServiceName, Optional<String> kerberosConfigPath, Optional<String> kerberosKeytabPath, Optional<String> kerberosCredentialCachePath, boolean kerberosUseCanonicalHostname, boolean kerberosEnabled) {
        this.session = new AtomicReference<ClientSession>(Objects.requireNonNull(session, "session is null"));
        this.sslSetup = builder -> OkHttpUtil.setupSsl((OkHttpClient.Builder)builder, (Optional)keystorePath, (Optional)keystorePassword, (Optional)truststorePath, (Optional)truststorePassword);
        OkHttpClient.Builder builder2 = new OkHttpClient.Builder();
        OkHttpUtil.setupTimeouts((OkHttpClient.Builder)builder2, (int)5, (TimeUnit)TimeUnit.SECONDS);
        OkHttpUtil.setupCookieJar((OkHttpClient.Builder)builder2);
        OkHttpUtil.setupSocksProxy((OkHttpClient.Builder)builder2, socksProxy);
        OkHttpUtil.setupHttpProxy((OkHttpClient.Builder)builder2, httpProxy);
        QueryRunner.setupBasicAuth(builder2, session, user, password);
        if (kerberosEnabled) {
            OkHttpUtil.setupKerberos((OkHttpClient.Builder)builder2, (String)kerberosRemoteServiceName.orElseThrow(() -> new ClientException("Kerberos remote service name must be set")), (boolean)kerberosUseCanonicalHostname, kerberosPrincipal, kerberosConfigPath.map(File::new), kerberosKeytabPath.map(File::new), kerberosCredentialCachePath.map(File::new));
        }
        this.httpClient = builder2.build();
    }

    public ClientSession getSession() {
        return this.session.get();
    }

    public void setSession(ClientSession session) {
        this.session.set(Objects.requireNonNull(session, "session is null"));
    }

    public Query startQuery(String query) {
        return new Query(this.startInternalQuery(this.session.get(), query));
    }

    public StatementClient startInternalQuery(String query) {
        return this.startInternalQuery(ClientSession.stripTransactionId((ClientSession)this.session.get()), query);
    }

    private StatementClient startInternalQuery(ClientSession session, String query) {
        OkHttpClient.Builder builder = this.httpClient.newBuilder();
        this.sslSetup.accept(builder);
        OkHttpClient client = builder.build();
        return new StatementClient(client, session, query);
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    private static void setupBasicAuth(OkHttpClient.Builder clientBuilder, ClientSession session, Optional<String> user, Optional<String> password) {
        if (user.isPresent() && password.isPresent()) {
            Preconditions.checkArgument((boolean)session.getServer().getScheme().equalsIgnoreCase("https"), (Object)"Authentication using username/password requires HTTPS to be enabled");
            clientBuilder.addInterceptor(OkHttpUtil.basicAuth((String)user.get(), (String)password.get()));
        }
    }
}

