/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.QueryRunner;
import com.facebook.presto.client.QueryData;
import com.facebook.presto.client.StatementClient;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import jline.console.completer.Completer;

public class TableNameCompleter
implements Completer,
Closeable {
    private static final long RELOAD_TIME_MINUTES = 2L;
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"completer-%s"));
    private final QueryRunner queryRunner;
    private final LoadingCache<String, List<String>> tableCache;
    private final LoadingCache<String, List<String>> functionCache;

    public TableNameCompleter(QueryRunner queryRunner) {
        this.queryRunner = Objects.requireNonNull(queryRunner, "queryRunner session was null!");
        this.tableCache = CacheBuilder.newBuilder().refreshAfterWrite(2L, TimeUnit.MINUTES).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::listTables), (Executor)this.executor));
        this.functionCache = CacheBuilder.newBuilder().build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::listFunctions), (Executor)this.executor));
    }

    private List<String> listTables(String schemaName) {
        return this.queryMetadata(String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", schemaName));
    }

    private List<String> listFunctions(String schemaName) {
        return this.queryMetadata("SHOW FUNCTIONS");
    }

    private List<String> queryMetadata(String query) {
        ImmutableList.Builder cache = ImmutableList.builder();
        try (StatementClient client = this.queryRunner.startInternalQuery(query);){
            while (client.isValid() && !Thread.currentThread().isInterrupted()) {
                QueryData results = client.currentData();
                if (results.getData() != null) {
                    for (List row : results.getData()) {
                        cache.add((Object)((String)row.get(0)));
                    }
                }
                client.advance();
            }
        }
        return cache.build();
    }

    public void populateCache() {
        String schemaName = this.queryRunner.getSession().getSchema();
        if (schemaName != null) {
            this.executor.execute(() -> {
                this.functionCache.refresh((Object)schemaName);
                this.tableCache.refresh((Object)schemaName);
            });
        }
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        if (cursor <= 0) {
            return cursor;
        }
        int blankPos = TableNameCompleter.findLastBlank(buffer.substring(0, cursor));
        String prefix = buffer.substring(blankPos + 1, cursor);
        String schemaName = this.queryRunner.getSession().getSchema();
        if (schemaName != null) {
            List functionNames = (List)this.functionCache.getIfPresent((Object)schemaName);
            List tableNames = (List)this.tableCache.getIfPresent((Object)schemaName);
            TreeSet<String> sortedCandidates = new TreeSet<String>();
            if (functionNames != null) {
                sortedCandidates.addAll(TableNameCompleter.filterResults(functionNames, prefix));
            }
            if (tableNames != null) {
                sortedCandidates.addAll(TableNameCompleter.filterResults(tableNames, prefix));
            }
            candidates.addAll(sortedCandidates);
        }
        return blankPos + 1;
    }

    private static int findLastBlank(String buffer) {
        for (int i = buffer.length() - 1; i >= 0; --i) {
            if (!Character.isWhitespace(buffer.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static List<String> filterResults(List<String> values, String prefix) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String value : values) {
            if (!value.startsWith(prefix)) continue;
            builder.add((Object)value);
        }
        return builder.build();
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }
}

