/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.ClientOptions;
import com.facebook.presto.cli.Completion;
import com.facebook.presto.cli.Help;
import com.facebook.presto.cli.LineReader;
import com.facebook.presto.cli.Query;
import com.facebook.presto.cli.QueryPreprocessor;
import com.facebook.presto.cli.QueryPreprocessorException;
import com.facebook.presto.cli.QueryRunner;
import com.facebook.presto.cli.TableNameCompleter;
import com.facebook.presto.cli.VersionOption;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.sql.parser.IdentifierSymbol;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.parser.StatementSplitter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import io.airlift.airline.Command;
import io.airlift.airline.HelpOption;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import io.airlift.units.Duration;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.inject.Inject;
import jline.console.history.FileHistory;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import jline.internal.Configuration;
import org.fusesource.jansi.AnsiConsole;

@Command(name="presto", description="Presto interactive console")
public class Console
implements Runnable {
    private static final String PROMPT_NAME = "presto";
    private static final Duration EXIT_DELAY = new Duration(3.0, TimeUnit.SECONDS);
    private static final SqlParser SQL_PARSER = new SqlParser(new SqlParserOptions().allowIdentifierSymbol(EnumSet.allOf(IdentifierSymbol.class)));
    private static final Pattern HISTORY_INDEX_PATTERN = Pattern.compile("!\\d+");
    @Inject
    public HelpOption helpOption;
    @Inject
    public VersionOption versionOption = new VersionOption();
    @Inject
    public ClientOptions clientOptions = new ClientOptions();

    @Override
    public void run() {
        boolean isFromFile;
        ClientSession session = this.clientOptions.toClientSession();
        boolean hasQuery = !Strings.isNullOrEmpty((String)this.clientOptions.execute);
        boolean bl = isFromFile = !Strings.isNullOrEmpty((String)this.clientOptions.file);
        if (!hasQuery && !isFromFile) {
            AnsiConsole.systemInstall();
        }
        Console.initializeLogging(this.clientOptions.logLevelsFile);
        String query = this.clientOptions.execute;
        if (hasQuery) {
            query = query + ";";
        }
        if (isFromFile) {
            if (hasQuery) {
                throw new RuntimeException("both --execute and --file specified");
            }
            try {
                query = Files.toString((File)new File(this.clientOptions.file), (Charset)StandardCharsets.UTF_8);
                hasQuery = true;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading from file %s: %s", this.clientOptions.file, e.getMessage()));
            }
        }
        AtomicBoolean exiting = new AtomicBoolean();
        Console.interruptThreadOnExit(Thread.currentThread(), exiting);
        try (QueryRunner queryRunner = new QueryRunner(session, Optional.ofNullable(this.clientOptions.socksProxy), Optional.ofNullable(this.clientOptions.httpProxy), Optional.ofNullable(this.clientOptions.keystorePath), Optional.ofNullable(this.clientOptions.keystorePassword), Optional.ofNullable(this.clientOptions.truststorePath), Optional.ofNullable(this.clientOptions.truststorePassword), Optional.ofNullable(this.clientOptions.user), this.clientOptions.password ? Optional.of(this.getPassword()) : Optional.empty(), Optional.ofNullable(this.clientOptions.krb5Principal), Optional.ofNullable(this.clientOptions.krb5RemoteServiceName), Optional.ofNullable(this.clientOptions.krb5ConfigPath), Optional.ofNullable(this.clientOptions.krb5KeytabPath), Optional.ofNullable(this.clientOptions.krb5CredentialCachePath), !this.clientOptions.krb5DisableRemoteServiceHostnameCanonicalization, this.clientOptions.authenticationEnabled);){
            if (hasQuery) {
                Console.executeCommand(queryRunner, query, this.clientOptions.outputFormat);
            } else {
                Console.runConsole(queryRunner, exiting);
            }
        }
    }

    private String getPassword() {
        Preconditions.checkState((this.clientOptions.user != null ? 1 : 0) != 0, (Object)"Username must be specified along with password");
        String defaultPassword = System.getenv("PRESTO_PASSWORD");
        if (defaultPassword != null) {
            return defaultPassword;
        }
        java.io.Console console = System.console();
        if (console == null) {
            throw new RuntimeException("No console from which to read password");
        }
        char[] password = console.readPassword("Password: ", new Object[0]);
        if (password != null) {
            return new String(password);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runConsole(QueryRunner queryRunner, AtomicBoolean exiting) {
        try (TableNameCompleter tableNameCompleter = new TableNameCompleter(queryRunner);
             LineReader reader = new LineReader((History)Console.getHistory(), Completion.commandCompleter(), Completion.lowerCaseCommandCompleter(), tableNameCompleter);){
            tableNameCompleter.populateCache();
            StringBuilder buffer = new StringBuilder();
            block43: while (!exiting.get()) {
                String prompt = PROMPT_NAME;
                String schema = queryRunner.getSession().getSchema();
                if (schema != null) {
                    prompt = prompt + ":" + schema;
                }
                if (buffer.length() > 0) {
                    prompt = Strings.repeat((String)" ", (int)(prompt.length() - 1)) + "-";
                }
                String commandPrompt = prompt + "> ";
                String line = reader.readLine(commandPrompt);
                if (reader.interrupted()) {
                    String partial = StatementSplitter.squeezeStatement((String)buffer.toString());
                    if (!partial.isEmpty()) {
                        reader.getHistory().add((CharSequence)partial);
                    }
                    buffer = new StringBuilder();
                    continue;
                }
                if (line == null) {
                    System.out.println();
                    return;
                }
                if (buffer.length() == 0) {
                    String command = line.trim();
                    if (HISTORY_INDEX_PATTERN.matcher(command).matches()) {
                        int historyIndex = Integer.parseInt(command.substring(1));
                        History history = reader.getHistory();
                        if (historyIndex <= 0 || historyIndex > history.index()) {
                            System.err.println("Command does not exist");
                            continue;
                        }
                        line = history.get(historyIndex - 1).toString();
                        System.out.println(commandPrompt + line);
                    }
                    if (command.endsWith(";")) {
                        command = command.substring(0, command.length() - 1).trim();
                    }
                    switch (command.toLowerCase(Locale.ENGLISH)) {
                        case "exit": 
                        case "quit": {
                            return;
                        }
                        case "history": {
                            Iterator iterator = reader.getHistory().iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block43;
                                History.Entry entry = (History.Entry)iterator.next();
                                System.out.printf("%5d  %s%n", entry.index() + 1, entry.value());
                            }
                        }
                        case "help": {
                            System.out.println();
                            System.out.println(Help.getHelpText());
                            continue block43;
                        }
                    }
                }
                buffer.append(line).append("\n");
                String sql = buffer.toString();
                StatementSplitter splitter = new StatementSplitter(sql, (Set)ImmutableSet.of((Object)";", (Object)"\\G"));
                for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
                    ClientOptions.OutputFormat outputFormat = ClientOptions.OutputFormat.ALIGNED;
                    if (split.terminator().equals("\\G")) {
                        outputFormat = ClientOptions.OutputFormat.VERTICAL;
                    }
                    Console.process(queryRunner, split.statement(), outputFormat, tableNameCompleter::populateCache, true);
                    reader.getHistory().add((CharSequence)(StatementSplitter.squeezeStatement((String)split.statement()) + split.terminator()));
                }
                buffer = new StringBuilder();
                String partial = splitter.getPartialStatement();
                if (partial.isEmpty()) continue;
                buffer.append(partial).append('\n');
            }
            return;
        }
        catch (IOException e) {
            System.err.println("Readline error: " + e.getMessage());
        }
    }

    private static void executeCommand(QueryRunner queryRunner, String query, ClientOptions.OutputFormat outputFormat) {
        StatementSplitter splitter = new StatementSplitter(query);
        for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
            if (StatementSplitter.isEmptyStatement((String)split.statement())) continue;
            Console.process(queryRunner, split.statement(), outputFormat, () -> {}, false);
        }
        if (!StatementSplitter.isEmptyStatement((String)splitter.getPartialStatement())) {
            System.err.println("Non-terminated statement: " + splitter.getPartialStatement());
        }
    }

    private static void process(QueryRunner queryRunner, String sql, ClientOptions.OutputFormat outputFormat, Runnable schemaChanged, boolean interactive) {
        block22: {
            String finalSql;
            try {
                finalSql = QueryPreprocessor.preprocessQuery(Optional.ofNullable(queryRunner.getSession().getCatalog()), Optional.ofNullable(queryRunner.getSession().getSchema()), sql);
            }
            catch (QueryPreprocessorException e) {
                System.err.println(e.getMessage());
                if (queryRunner.getSession().isDebug()) {
                    e.printStackTrace();
                }
                return;
            }
            try (Query query = queryRunner.startQuery(finalSql);){
                query.renderOutput(System.out, outputFormat, interactive);
                ClientSession session = queryRunner.getSession();
                if (query.getSetCatalog().isPresent() || query.getSetSchema().isPresent()) {
                    session = ClientSession.withCatalogAndSchema((ClientSession)session, (String)query.getSetCatalog().orElse(session.getCatalog()), (String)query.getSetSchema().orElse(session.getSchema()));
                    schemaChanged.run();
                }
                if (!query.getSetSessionProperties().isEmpty() || !query.getResetSessionProperties().isEmpty()) {
                    HashMap<String, String> sessionProperties = new HashMap<String, String>(session.getProperties());
                    sessionProperties.putAll(query.getSetSessionProperties());
                    sessionProperties.keySet().removeAll(query.getResetSessionProperties());
                    session = ClientSession.withProperties((ClientSession)session, sessionProperties);
                }
                if (!query.getAddedPreparedStatements().isEmpty() || !query.getDeallocatedPreparedStatements().isEmpty()) {
                    HashMap<String, String> preparedStatements = new HashMap<String, String>(session.getPreparedStatements());
                    preparedStatements.putAll(query.getAddedPreparedStatements());
                    preparedStatements.keySet().removeAll(query.getDeallocatedPreparedStatements());
                    session = ClientSession.withPreparedStatements((ClientSession)session, preparedStatements);
                }
                if (query.isClearTransactionId()) {
                    session = ClientSession.stripTransactionId((ClientSession)session);
                }
                if (query.getStartedTransactionId() != null) {
                    session = ClientSession.withTransactionId((ClientSession)session, (String)query.getStartedTransactionId());
                }
                queryRunner.setSession(session);
            }
            catch (RuntimeException e) {
                System.err.println("Error running command: " + e.getMessage());
                if (!queryRunner.getSession().isDebug()) break block22;
                e.printStackTrace();
            }
        }
    }

    private static MemoryHistory getHistory() {
        FileHistory history;
        File historyFile = new File(Configuration.getUserHome(), ".presto_history");
        try {
            history = new FileHistory(historyFile);
            history.setMaxSize(10000);
        }
        catch (IOException e) {
            System.err.printf("WARNING: Failed to load history file (%s): %s. History will not be available during this session.%n", historyFile, e.getMessage());
            history = new MemoryHistory();
        }
        history.setAutoTrim(true);
        return history;
    }

    private static void initializeLogging(String logLevelsFile) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            LoggingConfiguration config = new LoggingConfiguration();
            if (logLevelsFile == null) {
                System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
                System.setErr(new PrintStream(ByteStreams.nullOutputStream()));
                config.setConsoleEnabled(false);
            } else {
                config.setLevelsFile(logLevelsFile);
            }
            Logging logging = Logging.initialize();
            logging.configure(config);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
    }

    private static void interruptThreadOnExit(Thread thread, AtomicBoolean exiting) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            exiting.set(true);
            thread.interrupt();
            try {
                thread.join(EXIT_DELAY.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }));
    }
}

