/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.client.ClientSession;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.airlift.airline.Option;
import io.airlift.http.client.spnego.KerberosConfig;
import io.airlift.units.Duration;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class ClientOptions {
    @Option(name={"--server"}, title="server", description="Presto server location (default: localhost:8080)")
    public String server = "localhost:8080";
    @Option(name={"--enable-authentication"}, title="enable authentication", description="Enable client authentication")
    public boolean authenticationEnabled;
    @Option(name={"--krb5-remote-service-name"}, title="krb5 remote service name", description="Remote peer's kerberos service name")
    public String krb5RemoteServiceName;
    @Option(name={"--krb5-config-path"}, title="krb5 config path", description="Kerberos config file path (default: /etc/krb5.conf)")
    public String krb5ConfigPath = "/etc/krb5.conf";
    @Option(name={"--krb5-keytab-path"}, title="krb5 keytab path", description="Kerberos key table path")
    public String krb5KeytabPath = "/etc/krb5.keytab";
    @Option(name={"--krb5-credential-cache-path"}, title="krb5 credential cache path", description="Kerberos credential cache path")
    public String krb5CredentialCachePath = ClientOptions.defaultCredentialCachePath();
    @Option(name={"--krb5-principal"}, title="krb5 principal", description="Kerberos principal to be used")
    public String krb5Principal;
    @Option(name={"--krb5-disable-remote-service-hostname-canonicalization"}, title="krb5 disable remote service hostname canonicalization", description="Disable service hostname canonicalization using the DNS reverse lookup")
    public boolean krb5DisableRemoteServiceHostnameCanonicalization;
    @Option(name={"--keystore-path"}, title="keystore path", description="Keystore path")
    public String keystorePath;
    @Option(name={"--keystore-password"}, title="keystore password", description="Keystore password")
    public String keystorePassword;
    @Option(name={"--truststore-path"}, title="truststore path", description="Truststore path")
    public String truststorePath;
    @Option(name={"--truststore-password"}, title="truststore password", description="Truststore password")
    public String truststorePassword;
    @Option(name={"--user"}, title="user", description="Username")
    public String user = System.getProperty("user.name");
    @Option(name={"--source"}, title="source", description="Name of source making query")
    public String source = "presto-cli";
    @Option(name={"--catalog"}, title="catalog", description="Default catalog")
    public String catalog;
    @Option(name={"--schema"}, title="schema", description="Default schema")
    public String schema;
    @Option(name={"-f", "--file"}, title="file", description="Execute statements from file and exit")
    public String file;
    @Option(name={"--debug"}, title="debug", description="Enable debug information")
    public boolean debug;
    @Option(name={"--log-levels-file"}, title="log levels", description="Configure log levels for debugging")
    public String logLevelsFile;
    @Option(name={"--execute"}, title="execute", description="Execute specified statements and exit")
    public String execute;
    @Option(name={"--output-format"}, title="output-format", description="Output format for batch mode [ALIGNED, VERTICAL, CSV, TSV, CSV_HEADER, TSV_HEADER, NULL] (default: CSV)")
    public OutputFormat outputFormat = OutputFormat.CSV;
    @Option(name={"--session"}, title="session", description="Session property (property can be used multiple times; format is key=value; use 'SHOW SESSION' to see available properties)")
    public final List<ClientSessionProperty> sessionProperties = new ArrayList<ClientSessionProperty>();
    @Option(name={"--socks-proxy"}, title="socks-proxy", description="SOCKS proxy to use for server connections")
    public HostAndPort socksProxy;
    @Option(name={"--client-request-timeout"}, title="client request timeout", description="Client request timeout (default: 2m)")
    public Duration clientRequestTimeout = new Duration(2.0, TimeUnit.MINUTES);

    public ClientSession toClientSession() {
        return new ClientSession(ClientOptions.parseServer(this.server), this.user, this.source, this.catalog, this.schema, TimeZone.getDefault().getID(), Locale.getDefault(), ClientOptions.toProperties(this.sessionProperties), Collections.emptyMap(), null, this.debug, this.clientRequestTimeout);
    }

    public KerberosConfig toKerberosConfig() {
        KerberosConfig config = new KerberosConfig();
        if (this.krb5ConfigPath != null) {
            config.setConfig(new File(this.krb5ConfigPath));
        }
        if (this.krb5KeytabPath != null) {
            config.setKeytab(new File(this.krb5KeytabPath));
        }
        if (this.krb5CredentialCachePath != null) {
            config.setCredentialCache(new File(this.krb5CredentialCachePath));
        }
        config.setUseCanonicalHostname(!this.krb5DisableRemoteServiceHostnameCanonicalization);
        return config;
    }

    public static URI parseServer(String server) {
        if ((server = server.toLowerCase(Locale.ENGLISH)).startsWith("http://") || server.startsWith("https://")) {
            return URI.create(server);
        }
        HostAndPort host = HostAndPort.fromString((String)server);
        try {
            return new URI("http", null, host.getHostText(), host.getPortOrDefault(80), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Map<String, String> toProperties(List<ClientSessionProperty> sessionProperties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ClientSessionProperty sessionProperty : sessionProperties) {
            String name = sessionProperty.getName();
            if (sessionProperty.getCatalog().isPresent()) {
                name = sessionProperty.getCatalog().get() + "." + name;
            }
            builder.put((Object)name, (Object)sessionProperty.getValue());
        }
        return builder.build();
    }

    private static String defaultCredentialCachePath() {
        String value = System.getenv("KRB5CCNAME");
        if (value != null && value.startsWith("FILE:")) {
            return value.substring("FILE:".length());
        }
        return value;
    }

    public static final class ClientSessionProperty {
        private static final Splitter NAME_VALUE_SPLITTER = Splitter.on((char)'=').limit(2);
        private static final Splitter NAME_SPLITTER = Splitter.on((char)'.');
        private final Optional<String> catalog;
        private final String name;
        private final String value;

        public ClientSessionProperty(String property) {
            List nameValue = NAME_VALUE_SPLITTER.splitToList((CharSequence)property);
            Preconditions.checkArgument((nameValue.size() == 2 ? 1 : 0) != 0, (String)"Session property: %s", (Object[])new Object[]{property});
            List nameParts = NAME_SPLITTER.splitToList((CharSequence)nameValue.get(0));
            Preconditions.checkArgument((nameParts.size() == 1 || nameParts.size() == 2 ? 1 : 0) != 0, (String)"Invalid session property: %s", (Object[])new Object[]{property});
            if (nameParts.size() == 1) {
                this.catalog = Optional.empty();
                this.name = (String)nameParts.get(0);
            } else {
                this.catalog = Optional.of(nameParts.get(0));
                this.name = (String)nameParts.get(1);
            }
            this.value = (String)nameValue.get(1);
            ClientSessionProperty.verifyProperty(this.catalog, this.name, this.value);
        }

        public ClientSessionProperty(Optional<String> catalog, String name, String value) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            this.name = Objects.requireNonNull(name, "name is null");
            this.value = Objects.requireNonNull(value, "value is null");
            ClientSessionProperty.verifyProperty(catalog, name, value);
        }

        private static void verifyProperty(Optional<String> catalog, String name, String value) {
            Preconditions.checkArgument((!catalog.isPresent() || !catalog.get().isEmpty() ? 1 : 0) != 0, (String)"Invalid session property: %s.%s:%s", (Object[])new Object[]{catalog, name, value});
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Session property name is empty");
            CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
            Preconditions.checkArgument((catalog.orElse("").indexOf(61) < 0 ? 1 : 0) != 0, (String)"Session property catalog must not contain '=': %s", (Object[])new Object[]{name});
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(catalog.orElse("")), (String)"Session property catalog is not US_ASCII: %s", (Object[])new Object[]{name});
            Preconditions.checkArgument((name.indexOf(61) < 0 ? 1 : 0) != 0, (String)"Session property name must not contain '=': %s", (Object[])new Object[]{name});
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(name), (String)"Session property name is not US_ASCII: %s", (Object[])new Object[]{name});
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(value), (String)"Session property value is not US_ASCII: %s", (Object[])new Object[]{value});
        }

        public Optional<String> getCatalog() {
            return this.catalog;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return (this.catalog.isPresent() ? this.catalog.get() + '.' : "") + this.name + '=' + this.value;
        }

        public int hashCode() {
            return Objects.hash(this.catalog, this.name, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ClientSessionProperty other = (ClientSessionProperty)obj;
            return Objects.equals(this.catalog, other.catalog) && Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
        }
    }

    public static enum OutputFormat {
        ALIGNED,
        VERTICAL,
        CSV,
        TSV,
        CSV_HEADER,
        TSV_HEADER,
        NULL;

    }
}

