/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

class NotBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression value;

    NotBytecodeExpression(BytecodeExpression value) {
        super(ParameterizedType.type(Boolean.TYPE));
        this.value = value;
        Preconditions.checkArgument((value.getType().getPrimitiveType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected value to be type boolean but is %s", (Object)value.getType());
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        LabelNode trueLabel = new LabelNode("true");
        LabelNode endLabel = new LabelNode("end");
        return new BytecodeBlock().append(this.value).ifTrueGoto(trueLabel).push(true).gotoLabel(endLabel).visitLabel(trueLabel).push(false).visitLabel(endLabel);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    protected String formatOneLine() {
        return "(!" + this.value + ")";
    }
}

