/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.AnnotationDefinition;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.InsnNode;

@NotThreadSafe
public class MethodDefinition {
    private final Scope scope;
    private final ClassDefinition declaringClass;
    private final EnumSet<Access> access;
    private final String name;
    private final List<AnnotationDefinition> annotations = new ArrayList<AnnotationDefinition>();
    private final ParameterizedType returnType;
    private final List<Parameter> parameters;
    private final List<ParameterizedType> parameterTypes;
    private final List<List<AnnotationDefinition>> parameterAnnotations;
    private final List<ParameterizedType> exceptions = new ArrayList<ParameterizedType>();
    private final BytecodeBlock body;
    private String comment;

    public MethodDefinition(ClassDefinition declaringClass, EnumSet<Access> access, String name, ParameterizedType returnType, Parameter ... parameters) {
        this(declaringClass, access, name, returnType, (Iterable<Parameter>)ImmutableList.copyOf((Object[])parameters));
    }

    public MethodDefinition(ClassDefinition declaringClass, EnumSet<Access> access, String name, ParameterizedType returnType, Iterable<Parameter> parameters) {
        this.declaringClass = declaringClass;
        this.body = new BytecodeBlock();
        this.access = access;
        this.name = name;
        this.returnType = returnType != null ? returnType : ParameterizedType.type(Void.TYPE);
        this.parameters = ImmutableList.copyOf(parameters);
        this.parameterTypes = Lists.transform(this.parameters, BytecodeExpression::getType);
        this.parameterAnnotations = ImmutableList.copyOf((Iterable)Iterables.transform(parameters, input -> new ArrayList()));
        Optional<ParameterizedType> thisType = Optional.empty();
        if (!access.contains((Object)Access.STATIC)) {
            thisType = Optional.of(declaringClass.getType());
        }
        this.scope = new Scope(thisType, parameters);
    }

    public ClassDefinition getDeclaringClass() {
        return this.declaringClass;
    }

    public List<AnnotationDefinition> getAnnotations() {
        return ImmutableList.copyOf(this.annotations);
    }

    public List<AnnotationDefinition> getParameterAnnotations(int index) {
        return ImmutableList.copyOf((Collection)this.parameterAnnotations.get(index));
    }

    public EnumSet<Access> getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public ParameterizedType getReturnType() {
        return this.returnType;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<ParameterizedType> getParameterTypes() {
        return this.parameterTypes;
    }

    public List<ParameterizedType> getExceptions() {
        return this.exceptions;
    }

    public MethodDefinition addException(Class<? extends Throwable> exceptionClass) {
        this.exceptions.add(ParameterizedType.type(exceptionClass));
        return this;
    }

    public MethodDefinition comment(String format, Object ... args) {
        this.comment = String.format(format, args);
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Variable getThis() {
        return this.scope.getThis();
    }

    public String getMethodDescriptor() {
        return MethodDefinition.methodDescription(this.returnType, this.parameterTypes);
    }

    public BytecodeBlock getBody() {
        return this.body;
    }

    public AnnotationDefinition declareAnnotation(Class<?> type) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.annotations.add(annotationDefinition);
        return annotationDefinition;
    }

    public AnnotationDefinition declareAnnotation(ParameterizedType type) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.annotations.add(annotationDefinition);
        return annotationDefinition;
    }

    public AnnotationDefinition declareParameterAnnotation(Class<?> type, int parameterIndex) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.parameterAnnotations.get(parameterIndex).add(annotationDefinition);
        return annotationDefinition;
    }

    public AnnotationDefinition declareParameterAnnotation(ParameterizedType type, int parameterIndex) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.parameterAnnotations.get(parameterIndex).add(annotationDefinition);
        return annotationDefinition;
    }

    public void visit(ClassVisitor visitor) {
        this.visit(visitor, false);
    }

    public void visit(ClassVisitor visitor, boolean addReturn) {
        String[] exceptions = new String[this.exceptions.size()];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptions[i] = this.exceptions.get(i).getClassName();
        }
        MethodVisitor methodVisitor = visitor.visitMethod(Access.toAccessModifier(this.access), this.name, this.getMethodDescriptor(), MethodDefinition.genericMethodSignature(this.returnType, this.parameterTypes), exceptions);
        if (methodVisitor == null) {
            return;
        }
        for (AnnotationDefinition annotation : this.annotations) {
            annotation.visitMethodAnnotation(methodVisitor);
        }
        for (int parameterIndex = 0; parameterIndex < this.parameterAnnotations.size(); ++parameterIndex) {
            List<AnnotationDefinition> parameterAnnotations1 = this.parameterAnnotations.get(parameterIndex);
            for (AnnotationDefinition parameterAnnotation : parameterAnnotations1) {
                parameterAnnotation.visitParameterAnnotation(parameterIndex, methodVisitor);
            }
        }
        methodVisitor.visitCode();
        MethodGenerationContext generationContext = new MethodGenerationContext(methodVisitor);
        generationContext.enterScope(this.scope);
        this.body.accept(methodVisitor, generationContext);
        if (addReturn) {
            new InsnNode(177).accept(methodVisitor);
        }
        generationContext.exitScope(this.scope);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        Joiner.on((char)' ').appendTo(sb, this.access).append(' ');
        sb.append(this.returnType.getJavaClassName()).append(' ');
        sb.append(this.name).append('(');
        Joiner.on((String)", ").appendTo(sb, Iterables.transform(this.parameters, Parameter::getSourceString)).append(')');
        return sb.toString();
    }

    public String toString() {
        return this.toSourceString();
    }

    public static String methodDescription(Class<?> returnType, Class<?> ... parameterTypes) {
        return MethodDefinition.methodDescription(returnType, ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static String methodDescription(Class<?> returnType, List<Class<?>> parameterTypes) {
        return MethodDefinition.methodDescription(ParameterizedType.type(returnType), Lists.transform(parameterTypes, ParameterizedType::type));
    }

    public static String methodDescription(ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        return MethodDefinition.methodDescription(returnType, (List<ParameterizedType>)ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static String methodDescription(ParameterizedType returnType, List<ParameterizedType> parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Joiner.on((String)"").appendTo(sb, Iterables.transform(parameterTypes, ParameterizedType::getType));
        sb.append(")");
        sb.append(returnType.getType());
        return sb.toString();
    }

    public static String genericMethodSignature(ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        return MethodDefinition.genericMethodSignature(returnType, (List<ParameterizedType>)ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static String genericMethodSignature(ParameterizedType returnType, List<ParameterizedType> parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Joiner.on((String)"").appendTo(sb, parameterTypes);
        sb.append(")");
        sb.append(returnType);
        return sb.toString();
    }
}

