/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.Constant;
import com.google.common.collect.ImmutableList;
import java.util.List;

class ConstantBytecodeExpression
extends BytecodeExpression {
    private final Constant value;

    public ConstantBytecodeExpression(Class<?> type, Constant value) {
        this(ParameterizedType.type(type), value);
    }

    public ConstantBytecodeExpression(ParameterizedType type, Constant value) {
        super(type);
        this.value = value;
    }

    @Override
    public Constant getBytecode(MethodGenerationContext generationContext) {
        return this.value;
    }

    @Override
    protected String formatOneLine() {
        return ConstantBytecodeExpression.renderConstant(this.value.getValue());
    }

    public static String renderConstant(Object value) {
        if (value instanceof Long) {
            return value + "L";
        }
        if (value instanceof Float) {
            return value + "f";
        }
        if (value instanceof ParameterizedType) {
            return ((ParameterizedType)value).getSimpleName() + ".class";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        return String.valueOf(value);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }
}

