/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class AndBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression left;
    private final BytecodeExpression right;

    AndBytecodeExpression(BytecodeExpression left, BytecodeExpression right) {
        super(ParameterizedType.type(Boolean.TYPE));
        this.left = Objects.requireNonNull(left, "left is null");
        Preconditions.checkArgument((left.getType().getPrimitiveType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected left to be type boolean but is %s", (Object[])new Object[]{left.getType()});
        this.right = Objects.requireNonNull(right, "right is null");
        Preconditions.checkArgument((right.getType().getPrimitiveType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected right to be type boolean but is %s", (Object[])new Object[]{right.getType()});
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        LabelNode falseLabel = new LabelNode("false");
        LabelNode endLabel = new LabelNode("end");
        return new BytecodeBlock().append(this.left).ifFalseGoto(falseLabel).append(this.right).ifFalseGoto(falseLabel).push(true).gotoLabel(endLabel).visitLabel(falseLabel).push(false).visitLabel(endLabel);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    protected String formatOneLine() {
        return "(" + this.left + " && " + this.right + ")";
    }
}

