/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.control;

import com.facebook.presto.bytecode.instruction.LabelNode;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CaseStatement
implements Comparable<CaseStatement> {
    private final int key;
    private final LabelNode label;

    public static CaseStatement caseStatement(int key, LabelNode label) {
        return new CaseStatement(label, key);
    }

    CaseStatement(LabelNode label, int key) {
        this.label = label;
        this.key = key;
    }

    public int getKey() {
        return this.key;
    }

    public LabelNode getLabel() {
        return this.label;
    }

    @Override
    public int compareTo(CaseStatement o) {
        return Integer.compare(this.key, o.key);
    }

    public int hashCode() {
        return this.key;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CaseStatement other = (CaseStatement)obj;
        return Objects.equals(this.key, other.key);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("label", (Object)this.label).toString();
    }
}

