/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.TypeInstruction;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class NewArrayBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression length;
    private final ParameterizedType type;

    public NewArrayBytecodeExpression(ParameterizedType type, int length) {
        this(type, BytecodeExpressions.constantInt(length));
    }

    public NewArrayBytecodeExpression(ParameterizedType type, BytecodeExpression length) {
        super(type);
        this.type = Objects.requireNonNull(type, "type is null");
        this.length = Objects.requireNonNull(length, "length is null");
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        if (this.type.getArrayComponentType().isPrimitive()) {
            return new BytecodeBlock().append(this.length).append(TypeInstruction.newPrimitiveArray(this.type.getArrayComponentType()));
        }
        return new BytecodeBlock().append(this.length).append(TypeInstruction.newObjectArray(this.type.getArrayComponentType()));
    }

    @Override
    protected String formatOneLine() {
        return "new " + this.getType().getArrayComponentType().getSimpleName() + "[" + this.length + "]";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }
}

