/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.nativecode;

import android.os.Build;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.webp.WebpSupportStatus;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.nativecode.StaticWebpNativeLoader;
import com.facebook.imagepipeline.nativecode.WebpTranscoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@DoNotStrip
public class WebpTranscoderImpl
implements WebpTranscoder {
    public boolean isWebpNativelySupported(ImageFormat webpFormat) {
        if (webpFormat == DefaultImageFormats.WEBP_SIMPLE) {
            return Build.VERSION.SDK_INT >= 14;
        }
        if (webpFormat == DefaultImageFormats.WEBP_LOSSLESS || webpFormat == DefaultImageFormats.WEBP_EXTENDED || webpFormat == DefaultImageFormats.WEBP_EXTENDED_WITH_ALPHA) {
            return WebpSupportStatus.sIsExtendedWebpSupported;
        }
        if (webpFormat == DefaultImageFormats.WEBP_ANIMATED) {
            return false;
        }
        throw new IllegalArgumentException("Image format is not a WebP.");
    }

    public void transcodeWebpToJpeg(InputStream inputStream, OutputStream outputStream, int quality) throws IOException {
        StaticWebpNativeLoader.ensure();
        WebpTranscoderImpl.nativeTranscodeWebpToJpeg((InputStream)Preconditions.checkNotNull((Object)inputStream), (OutputStream)Preconditions.checkNotNull((Object)outputStream), quality);
    }

    public void transcodeWebpToPng(InputStream inputStream, OutputStream outputStream) throws IOException {
        StaticWebpNativeLoader.ensure();
        WebpTranscoderImpl.nativeTranscodeWebpToPng((InputStream)Preconditions.checkNotNull((Object)inputStream), (OutputStream)Preconditions.checkNotNull((Object)outputStream));
    }

    @DoNotStrip
    private static native void nativeTranscodeWebpToJpeg(InputStream var0, OutputStream var1, int var2) throws IOException;

    @DoNotStrip
    private static native void nativeTranscodeWebpToPng(InputStream var0, OutputStream var1) throws IOException;
}

