/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.flipper.plugins.network;

import android.util.Base64;
import com.facebook.flipper.core.ErrorReportingRunnable;
import com.facebook.flipper.core.FlipperArray;
import com.facebook.flipper.core.FlipperObject;
import com.facebook.flipper.plugins.common.BufferingFlipperPlugin;
import com.facebook.flipper.plugins.network.NetworkReporter;
import com.facebook.flipper.plugins.network.NetworkResponseFormatter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class NetworkFlipperPlugin
extends BufferingFlipperPlugin
implements NetworkReporter {
    public static final String ID = "Network";
    private static final int MAX_BODY_SIZE_IN_BYTES = 0x100000;
    private final List<NetworkResponseFormatter> mFormatters;

    public NetworkFlipperPlugin() {
        this(null);
    }

    public NetworkFlipperPlugin(List<NetworkResponseFormatter> formatters) {
        this.mFormatters = formatters;
    }

    public String getId() {
        return ID;
    }

    @Override
    public void reportRequest(final NetworkReporter.RequestInfo requestInfo) {
        new ErrorReportingRunnable(this.getConnection()){

            protected void runOrThrow() throws Exception {
                FlipperObject request = new FlipperObject.Builder().put("id", requestInfo.requestId).put("timestamp", Long.valueOf(requestInfo.timeStamp)).put("method", requestInfo.method).put("url", requestInfo.uri).put("headers", NetworkFlipperPlugin.this.toFlipperObject(requestInfo.headers)).put("data", NetworkFlipperPlugin.this.toBase64(requestInfo.body)).build();
                NetworkFlipperPlugin.this.send("newRequest", request);
            }
        }.run();
    }

    @Override
    public void reportResponse(final NetworkReporter.ResponseInfo responseInfo) {
        ErrorReportingRunnable job = new ErrorReportingRunnable(this.getConnection()){

            protected void runOrThrow() throws Exception {
                if (NetworkFlipperPlugin.shouldStripResponseBody(responseInfo)) {
                    responseInfo.body = null;
                }
                int numChunks = responseInfo.body == null ? 1 : (int)Math.ceil((double)responseInfo.body.length / 1048576.0);
                for (int i = 0; i < numChunks; ++i) {
                    byte[] chunk = responseInfo.body == null ? null : Arrays.copyOfRange(responseInfo.body, i * 0x100000, Math.min((i + 1) * 0x100000, responseInfo.body.length));
                    FlipperObject response = i == 0 ? new FlipperObject.Builder().put("id", responseInfo.requestId).put("timestamp", Long.valueOf(responseInfo.timeStamp)).put("status", Integer.valueOf(responseInfo.statusCode)).put("reason", responseInfo.statusReason).put("headers", NetworkFlipperPlugin.this.toFlipperObject(responseInfo.headers)).put("isMock", Boolean.valueOf(responseInfo.isMock)).put("data", NetworkFlipperPlugin.this.toBase64(chunk)).put("totalChunks", Integer.valueOf(numChunks)).put("index", Integer.valueOf(i)).build() : new FlipperObject.Builder().put("id", responseInfo.requestId).put("timestamp", Long.valueOf(responseInfo.timeStamp)).put("totalChunks", Integer.valueOf(numChunks)).put("index", Integer.valueOf(i)).put("data", NetworkFlipperPlugin.this.toBase64(chunk)).build();
                    NetworkFlipperPlugin.this.send(numChunks == 1 ? "newResponse" : "partialResponse", response);
                }
            }
        };
        if (this.mFormatters != null) {
            for (NetworkResponseFormatter formatter : this.mFormatters) {
                if (!formatter.shouldFormat(responseInfo)) continue;
                formatter.format(responseInfo, new NetworkResponseFormatter.OnCompletionListener((Runnable)job){
                    final /* synthetic */ Runnable val$job;
                    {
                        this.val$job = runnable;
                    }

                    @Override
                    public void onCompletion(String json) {
                        responseInfo.body = json.getBytes();
                        this.val$job.run();
                    }
                });
                return;
            }
        }
        job.run();
    }

    private String toBase64(@Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(Base64.encode((byte[])bytes, (int)0));
    }

    private FlipperArray toFlipperObject(List<NetworkReporter.Header> headers) {
        FlipperArray.Builder list = new FlipperArray.Builder();
        for (NetworkReporter.Header header : headers) {
            list.put(new FlipperObject.Builder().put("key", header.name).put("value", header.value));
        }
        return list.build();
    }

    private static boolean shouldStripResponseBody(NetworkReporter.ResponseInfo responseInfo) {
        NetworkReporter.Header contentType = responseInfo.getFirstHeader("content-type");
        if (contentType == null) {
            return false;
        }
        return contentType.value.contains("video/") || contentType.value.contains("application/zip");
    }
}

