/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.bridge.exoplayer;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.Keep;
import android.util.Log;
import android.view.Surface;
import com.facebook.ads.internal.api.BuildConfigApi;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;

@Keep
@TargetApi(value=14)
public class ExoPlayerBridge {
    public static final int STATE_IDLE = 1;
    public static final int STATE_BUFFERING = 2;
    public static final int STATE_READY = 3;
    public static final int STATE_ENDED = 4;
    private final SimpleExoPlayer mExoPlayer;
    private final DefaultBandwidthMeter mBandwidthMeter = new DefaultBandwidthMeter();

    public ExoPlayerBridge(Context context) {
        AdaptiveTrackSelection.Factory trackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)this.mBandwidthMeter);
        DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)trackSelectionFactory);
        DefaultLoadControl loadControl = new DefaultLoadControl();
        this.mExoPlayer = ExoPlayerFactory.newSimpleInstance((Context)context, (TrackSelector)trackSelector, (LoadControl)loadControl);
    }

    public void prepare(Context context, Uri videoUri) {
        DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(context, Util.getUserAgent((Context)context, (String)"ads"), (TransferListener)this.mBandwidthMeter);
        DefaultExtractorsFactory extractorsFactory = new DefaultExtractorsFactory();
        ExtractorMediaSource mediaSource = new ExtractorMediaSource(videoUri, (DataSource.Factory)dataSourceFactory, (ExtractorsFactory)extractorsFactory, null, null);
        this.mExoPlayer.prepare((MediaSource)mediaSource);
    }

    public boolean hasSound() {
        return this.mExoPlayer != null && this.mExoPlayer.getAudioFormat() != null;
    }

    public long getCurrentPosition() {
        return this.mExoPlayer.getCurrentPosition();
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.mExoPlayer.setPlayWhenReady(playWhenReady);
    }

    public void seekTo(long positionMs) {
        this.mExoPlayer.seekTo(positionMs);
    }

    public void stop() {
        this.mExoPlayer.stop();
    }

    public void release() {
        this.mExoPlayer.release();
    }

    public long getDuration() {
        return this.mExoPlayer.getDuration();
    }

    public void setVolume(float audioVolume) {
        this.mExoPlayer.setVolume(audioVolume);
    }

    public void setVideoListener(final VideoListener listener) {
        this.mExoPlayer.setVideoListener(new SimpleExoPlayer.VideoListener(){

            public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
                listener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
            }

            public void onRenderedFirstFrame() {
            }
        });
    }

    public void addListener(final EventListener listener) {
        this.mExoPlayer.addListener((Player.EventListener)new ExoPlayer.EventListener(){

            public void onTimelineChanged(Timeline timeline, Object manifest) {
            }

            public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
            }

            public void onLoadingChanged(boolean isLoading) {
            }

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                listener.onPlayerStateChanged(playWhenReady, playbackState);
            }

            public void onPlayerError(ExoPlaybackException error) {
                listener.onPlayerError();
            }

            public void onPositionDiscontinuity() {
            }

            public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            }

            public void onPositionDiscontinuity(int reason) {
            }

            public void onTimelineChanged(Timeline timeline, Object manifest, int reason) {
            }

            public void onRepeatModeChanged(int repeatMode) {
            }

            public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
            }

            public void onSeekProcessed() {
            }
        });
    }

    public boolean getPlayWhenReady() {
        return this.mExoPlayer.getPlayWhenReady();
    }

    public void setVideoSurface(Surface surface) {
        this.mExoPlayer.setVideoSurface(surface);
    }

    public void seekToDefaultPosition() {
        this.mExoPlayer.seekToDefaultPosition();
    }

    public int getBufferedPercentage() {
        return this.mExoPlayer.getBufferedPercentage();
    }

    public int getAudioSessionId() {
        return this.mExoPlayer.getAudioSessionId();
    }

    @SuppressLint(value={"CatchGeneralException"})
    public static boolean hasExoPlayer() {
        try {
            Class.forName(ExoPlayer.class.getName());
            return true;
        }
        catch (Throwable t) {
            if (BuildConfigApi.isDebug()) {
                Log.e((String)"FBAudienceNetwork", (String)"Can't find ExoPlayer class", (Throwable)t);
            }
            return false;
        }
    }

    @Keep
    public static interface VideoListener {
        public void onVideoSizeChanged(int var1, int var2, int var3, float var4);
    }

    @Keep
    public static interface EventListener {
        public void onPlayerStateChanged(boolean var1, int var2);

        public void onPlayerError();
    }
}

