/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.facebook.ads.internal.tm;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ts
extends tm {
    private final WifiManager e;
    private final Context f;

    public ts(Context context) {
        this.e = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        this.f = context;
    }

    @SuppressLint(value={"MissingPermission"})
    private void a(boolean bl2) {
        if (!this.a(this.f, "android.permission.ACCESS_WIFI_STATE")) {
            this.a(bl2 ? "wifi_state" : "wifi_ssid", "no_permission", false);
            return;
        }
        if (this.e == null) {
            this.a(bl2 ? "wifi_state" : "wifi_ssid", "error", false);
            return;
        }
        if (!this.e.isWifiEnabled()) {
            this.a(bl2 ? "wifi_state" : "wifi_ssid", "unknown", false);
            return;
        }
        WifiInfo wifiInfo = this.e.getConnectionInfo();
        if (wifiInfo == null) {
            this.a(bl2 ? "wifi_state" : "wifi_ssid", "null", true);
            return;
        }
        NetworkInfo.DetailedState detailedState = WifiInfo.getDetailedStateOf((SupplicantState)wifiInfo.getSupplicantState());
        if (detailedState == null) {
            this.a(bl2 ? "wifi_state" : "wifi_ssid", "error", false);
            return;
        }
        if (bl2) {
            this.a("wifi_state", detailedState.toString(), true);
        } else if (detailedState == NetworkInfo.DetailedState.CONNECTED || detailedState == NetworkInfo.DetailedState.OBTAINING_IPADDR) {
            String string = wifiInfo.getSSID();
            if (string != null) {
                string = string.replaceAll("(^\")|(\"$)", "");
            }
            this.a("wifi_ssid", string, true);
        } else {
            this.a("wifi_ssid", "unknown", false);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void b() {
        if (c < 21) {
            this.a("networks", "unknown", false);
            return;
        }
        if (!this.a(this.f, "android.permission.ACCESS_NETWORK_STATE")) {
            this.a("networks", "no_permission", false);
            return;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)this.f.getSystemService("connectivity");
        if (connectivityManager == null) {
            this.a("networks", "error", false);
            return;
        }
        if (c >= 21) {
            Network[] networkArray = connectivityManager.getAllNetworks();
            JSONArray jSONArray = new JSONArray();
            for (Network network : networkArray) {
                JSONObject jSONObject = new JSONObject();
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
                if (networkCapabilities != null) {
                    try {
                        jSONObject.put("network_capabilities_info", (Object)networkCapabilities.toString());
                        jSONObject.put("network_capabilities_internet", networkCapabilities.hasCapability(12));
                        jSONObject.put("network_capabilities_not_vpn", networkCapabilities.hasCapability(15));
                        Integer n2 = -1;
                        if (networkCapabilities.hasTransport(0)) {
                            n2 = 0;
                        } else if (networkCapabilities.hasTransport(1)) {
                            n2 = 1;
                        } else if (networkCapabilities.hasTransport(2)) {
                            n2 = 2;
                        } else if (networkCapabilities.hasTransport(3)) {
                            n2 = 3;
                        } else if (networkCapabilities.hasTransport(4)) {
                            n2 = 4;
                        } else if (networkCapabilities.hasTransport(5) && c >= 26) {
                            n2 = 5;
                        }
                        jSONObject.put("network_transport_type", (Object)n2);
                        jSONArray.put((Object)jSONObject);
                    }
                    catch (JSONException jSONException) {
                        this.a("networks", "error", false);
                    }
                    catch (NullPointerException nullPointerException) {
                        this.a("networks", "error", false);
                    }
                    continue;
                }
                this.a("networks", "unknown", false);
            }
            this.a("networks", jSONArray, true);
        }
    }

    public void a() {
        ts ts2 = this;
        ts2.a("system_os_architecture", System.getProperty("os.arch"), true);
        ts2.a("system_os_name", System.getProperty("os.name"), true);
        ts2.a("system_os_version", System.getProperty("os.version"), true);
        ts2 = this;
        ts2.a("http_user_agent", System.getProperty("http.agent"), true);
        ts2 = this;
        ts2.a("http_proxy_host", System.getProperty("http.proxyHost"), true);
        ts2.a("http_proxy_port", System.getProperty("http.proxyPort"), true);
        ts2.a("http_proxy_user", System.getProperty("http.proxyUser"), true);
        ts2.a("http_proxy_non_proxy_host", System.getProperty("http.nonProxyHosts"), true);
        ts2 = this;
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = new JSONArray();
        String string = "";
        String string2 = null;
        HashMap<String, JSONArray> hashMap = new HashMap<String, JSONArray>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    JSONObject jSONObject;
                    Object object;
                    NetworkInterface networkInterface = enumeration.nextElement();
                    if (networkInterface == null || !networkInterface.isUp()) continue;
                    byte[] byArray = networkInterface.getHardwareAddress();
                    if (byArray != null) {
                        object = new StringBuilder();
                        for (int i2 = 0; i2 < byArray.length; ++i2) {
                            ((StringBuilder)object).append(String.format("%02X%s", byArray[i2], i2 < byArray.length - 1 ? "-" : ""));
                        }
                        string = ((StringBuilder)object).toString();
                    }
                    if (string2 != null && string2.equals(string) && hashMap.containsKey(string)) {
                        jSONArray2 = (JSONArray)hashMap.get(string);
                    } else if (string2 != null && !string2.equals(string)) {
                        jSONObject = new JSONObject();
                        jSONObject.put("inet_addresses", (Object)jSONArray2);
                        jSONObject.put("network_mac", (Object)string2);
                        jSONObject.put("network_virtual", networkInterface.isVirtual());
                        jSONArray2 = new JSONArray();
                        jSONArray.put((Object)jSONObject);
                    }
                    object = networkInterface.getInetAddresses();
                    while (object.hasMoreElements()) {
                        JSONObject jSONObject2 = new JSONObject();
                        InetAddress inetAddress = (InetAddress)object.nextElement();
                        jSONObject2.put("network_ip", (Object)inetAddress.getHostAddress());
                        jSONObject2.put("network_loopback", inetAddress.isLoopbackAddress());
                        if (jSONArray2 == null) continue;
                        jSONArray2.put((Object)jSONObject2);
                    }
                    hashMap.put(string, jSONArray2);
                    string2 = string;
                    if (enumeration.hasMoreElements()) continue;
                    jSONObject = new JSONObject();
                    jSONObject.put("inet_addresses", (Object)jSONArray2);
                    jSONObject.put("network_mac", (Object)string2);
                    jSONObject.put("network_virtual", networkInterface.isVirtual());
                    jSONArray.put((Object)jSONObject);
                }
                ts2.a("network_interfaces", jSONArray, true);
            } else {
                ts2.a("network_interfaces", null, true);
            }
        }
        catch (SocketException socketException) {
            ts2.a("network_interfaces", "error", false);
        }
        catch (JSONException jSONException) {
            ts2.a("network_interfaces", "error", false);
        }
        this.b();
        ts2 = this;
        ts2.a("socks_proxy_host", System.getProperty("socksProxyHost"), true);
        ts2.a("socks_proxy_port", System.getProperty("socksProxyPort"), true);
        ts2.a("socks_proxy_version", System.getProperty("socksProxyVersion"), true);
        ts2.a("socks_proxy_user", System.getProperty("java.net.socks.username"), true);
        this.a(true);
        this.a(false);
    }
}

