/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.lint.checks;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.text.MessageFormat;

public class DependenciesDetector
extends Detector
implements Detector.GradleScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(DependenciesDetector.class, Scope.GRADLE_SCOPE);
    public static final Issue ADAPTER_VERSION_ISSUE = Issue.create((String)"FBAdapterVersionMismatch", (String)"Audience Network version may not work with the Audience Network SDK", (String)"Adapters are certified with specific versions of the SDK. Ensure to use the same major and minor version for both. Please visit https://developers.google.com/admob/android/facebook#android_studio_integration_recommended for further details.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);

    public void afterCheckFile(Context context) {
        MavenCoordinates sdk = null;
        MavenCoordinates adMobAdapter = null;
        Dependencies compileDependencies = DependenciesDetector.getCompileDependencies(context.getProject());
        if (compileDependencies == null) {
            return;
        }
        for (AndroidLibrary library : compileDependencies.getLibraries()) {
            MavenCoordinates resolvedCoordinates = library.getResolvedCoordinates();
            if (resolvedCoordinates.getGroupId().equals("com.facebook.android") && resolvedCoordinates.getArtifactId().equals("audience-network-sdk")) {
                sdk = resolvedCoordinates;
                continue;
            }
            if (!resolvedCoordinates.getGroupId().equals("com.google.ads.mediation") || !resolvedCoordinates.getArtifactId().equals("facebook")) continue;
            adMobAdapter = resolvedCoordinates;
        }
        if (sdk != null) {
            this.checkAdapter(context, sdk, adMobAdapter);
        }
    }

    private void checkAdapter(Context context, MavenCoordinates sdk, MavenCoordinates adapter) {
        if (adapter != null && !DependenciesDetector.isValidVersion(sdk.getVersion(), adapter.getVersion())) {
            String dependencyName = MessageFormat.format("{0}:{1}:{2}", adapter.getGroupId(), adapter.getArtifactId(), adapter.getVersion());
            Location location = LintUtils.guessGradleLocation((LintClient)context.getClient(), (File)context.getProject().getDir(), (String)dependencyName);
            String message = MessageFormat.format("Version compatibility mismatch: SDK {0}, adapter {1}", sdk.getVersion(), adapter.getVersion());
            context.report(ADAPTER_VERSION_ISSUE, location, message);
        }
    }

    public static boolean isValidVersion(String sdkVersion, String adapterVersion) {
        String[] sdk = sdkVersion.split("\\.");
        if (sdk.length < 2) {
            return true;
        }
        String[] adapter = adapterVersion.split("\\.");
        if (adapter.length < 2) {
            return true;
        }
        return sdk[0].equals(adapter[0]) && sdk[1].equals(adapter[1]);
    }

    public static Dependencies getCompileDependencies(Project project) {
        if (!project.isGradleProject()) {
            return null;
        }
        Variant variant = project.getCurrentVariant();
        if (variant == null) {
            return null;
        }
        AndroidArtifact artifact = variant.getMainArtifact();
        return artifact.getDependencies();
    }
}

