/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.android.scissors;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.graphics.Rect;
import com.lyft.android.scissors.BitmapLoader;
import com.lyft.android.scissors.CropView;
import com.lyft.android.scissors.GlideBitmapLoader;

class CropViewExtensions {
    CropViewExtensions() {
    }

    static void pickUsing(Activity activity, int requestCode) {
        activity.startActivityForResult(CropViewExtensions.createChooserIntent(), requestCode);
    }

    static void pickUsing(Fragment fragment, int requestCode) {
        fragment.startActivityForResult(CropViewExtensions.createChooserIntent(), requestCode);
    }

    private static Intent createChooserIntent() {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        return Intent.createChooser((Intent)intent, null);
    }

    static BitmapLoader resolveBitmapLoader(CropView cropView) {
        return GlideBitmapLoader.createUsing(cropView);
    }

    static Rect computeTargetSize(int sourceWidth, int sourceHeight, int viewportWidth, int viewportHeight) {
        if (sourceWidth == viewportWidth && sourceHeight == viewportHeight) {
            return new Rect(0, 0, viewportWidth, viewportHeight);
        }
        float scale = sourceWidth * viewportHeight > viewportWidth * sourceHeight ? (float)viewportHeight / (float)sourceHeight : (float)viewportWidth / (float)sourceWidth;
        int recommendedWidth = (int)((float)sourceWidth * scale + 0.5f);
        int recommendedHeight = (int)((float)sourceHeight * scale + 0.5f);
        return new Rect(0, 0, recommendedWidth, recommendedHeight);
    }
}

