/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.android.scissors;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import com.lyft.android.scissors.CropView;
import com.lyft.android.scissors.Utils;
import java.io.File;
import java.io.OutputStream;
import java.util.concurrent.Future;

public class CropRequest {
    private final CropView cropView;
    private Bitmap.CompressFormat format = Bitmap.CompressFormat.JPEG;
    private int quality = 100;

    CropRequest(@NonNull CropView cropView) {
        Utils.checkNotNull((Object)cropView, "cropView == null");
        this.cropView = cropView;
    }

    public CropRequest format(@NonNull Bitmap.CompressFormat format) {
        Utils.checkNotNull(format, "format == null");
        this.format = format;
        return this;
    }

    public CropRequest quality(int quality) {
        Utils.checkArg(quality >= 0 && quality <= 100, "quality must be 0..100");
        this.quality = quality;
        return this;
    }

    public Future<Void> into(@NonNull File file) {
        Bitmap croppedBitmap = this.cropView.crop();
        return Utils.flushToFile(croppedBitmap, this.format, this.quality, file);
    }

    public Future<Void> into(@NonNull OutputStream outputStream, boolean closeWhenDone) {
        Bitmap croppedBitmap = this.cropView.crop();
        return Utils.flushToStream(croppedBitmap, this.format, this.quality, outputStream, closeWhenDone);
    }
}

