/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.android.scissors;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.Log;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

class Utils {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    private static final String TAG = "scissors.Utils";

    Utils() {
    }

    public static void checkArg(boolean expression, String msg) {
        if (!expression) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkNotNull(Object object, String msg) {
        if (object == null) {
            throw new NullPointerException(msg);
        }
    }

    public static Bitmap asBitmap(Drawable drawable, int minWidth, int minHeight) {
        Rect tmpRect = new Rect();
        drawable.copyBounds(tmpRect);
        if (tmpRect.isEmpty()) {
            tmpRect.set(0, 0, Math.max(minWidth, drawable.getIntrinsicWidth()), Math.max(minHeight, drawable.getIntrinsicHeight()));
            drawable.setBounds(tmpRect);
        }
        Bitmap bitmap = Bitmap.createBitmap((int)tmpRect.width(), (int)tmpRect.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        drawable.draw(new Canvas(bitmap));
        return bitmap;
    }

    public static Future<Void> flushToFile(Bitmap bitmap, Bitmap.CompressFormat format, int quality, File file) {
        return EXECUTOR_SERVICE.submit(() -> {
            FileOutputStream outputStream = null;
            try {
                file.getParentFile().mkdirs();
                outputStream = new FileOutputStream(file);
                bitmap.compress(format, quality, (OutputStream)outputStream);
                outputStream.flush();
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(outputStream);
                catch (Throwable throwable2) {
                    Utils.closeQuietly(outputStream);
                    throw throwable2;
                }
            }
            Utils.closeQuietly(outputStream);
        }, null);
    }

    public static Future<Void> flushToStream(Bitmap bitmap, Bitmap.CompressFormat format, int quality, OutputStream outputStream, boolean closeWhenDone) {
        return EXECUTOR_SERVICE.submit(() -> {
            try {
                bitmap.compress(format, quality, outputStream);
                outputStream.flush();
            }
            catch (Throwable throwable) {
            }
            finally {
                if (closeWhenDone) {
                    Utils.closeQuietly(outputStream);
                }
            }
        }, null);
    }

    private static void closeQuietly(@Nullable OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error attempting to close stream.", (Throwable)e);
        }
    }
}

