/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.android.scissors;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import com.lyft.android.scissors.CropViewConfig;
import com.lyft.android.scissors.TouchPoint;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

class TouchManager {
    private static final int MINIMUM_FLING_VELOCITY = 2500;
    private final CropViewConfig cropViewConfig;
    private final ScaleGestureDetector scaleGestureDetector;
    private final GestureDetector gestureDetector;
    private float minimumScale;
    private float maximumScale;
    private Rect imageBounds;
    private float aspectRatio;
    private int viewportWidth;
    private int viewportHeight;
    private int bitmapWidth;
    private int bitmapHeight;
    private int verticalLimit;
    private int horizontalLimit;
    private float scale = -1.0f;
    private final TouchPoint position = new TouchPoint();
    private final ImageView imageView;
    private final GestureAnimator gestureAnimator = new GestureAnimator(new GestureAnimator.OnAnimationUpdateListener(){

        @Override
        public void onAnimationUpdate(int animationType, float animationValue) {
            if (animationType == 0) {
                TouchManager.this.position.set(animationValue, TouchManager.this.position.getY());
                TouchManager.this.ensureInsideViewport();
            } else if (animationType == 1) {
                TouchManager.this.position.set(TouchManager.this.position.getX(), animationValue);
                TouchManager.this.ensureInsideViewport();
            } else if (animationType == 2) {
                TouchManager.this.scale = animationValue;
                TouchManager.this.setLimits();
            }
            TouchManager.this.imageView.invalidate();
        }

        @Override
        public void onAnimationFinished() {
            TouchManager.this.ensureInsideViewport();
        }
    });

    public TouchManager(final ImageView imageView, CropViewConfig cropViewConfig) {
        this.imageView = imageView;
        this.scaleGestureDetector = new ScaleGestureDetector(imageView.getContext(), new ScaleGestureDetector.OnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector detector) {
                TouchManager.this.scale = TouchManager.this.calculateScale(detector.getScaleFactor());
                TouchManager.this.setLimits();
                return true;
            }

            public boolean onScaleBegin(ScaleGestureDetector detector) {
                return true;
            }

            public void onScaleEnd(ScaleGestureDetector detector) {
            }
        });
        this.gestureDetector = new GestureDetector(imageView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDown(MotionEvent e) {
                return true;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (e2.getPointerCount() != 1) {
                    return true;
                }
                TouchPoint delta = new TouchPoint(-distanceX, -distanceY);
                TouchManager.this.position.add(delta);
                TouchManager.this.ensureInsideViewport();
                return true;
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                velocityX /= 2.0f;
                velocityY /= 2.0f;
                if (Math.abs(velocityX) < 2500.0f) {
                    velocityX = 0.0f;
                }
                if (Math.abs(velocityY) < 2500.0f) {
                    velocityY = 0.0f;
                }
                if (velocityX == 0.0f && velocityY == 0.0f) {
                    return true;
                }
                int width = (int)((float)((TouchManager)TouchManager.this).imageBounds.right * TouchManager.this.scale);
                int height = (int)((float)((TouchManager)TouchManager.this).imageBounds.bottom * TouchManager.this.scale);
                OverScroller scroller = new OverScroller(imageView.getContext());
                scroller.fling((int)e1.getX(), (int)e1.getY(), (int)velocityX, (int)velocityY, -width, width, -height, height);
                TouchPoint target = new TouchPoint(scroller.getFinalX(), scroller.getFinalY());
                float x = velocityX == 0.0f ? TouchManager.this.position.getX() : target.getX() * TouchManager.this.scale;
                float y = velocityY == 0.0f ? TouchManager.this.position.getY() : target.getY() * TouchManager.this.scale;
                TouchManager.this.gestureAnimator.animateTranslation(TouchManager.this.position.getX(), x, TouchManager.this.position.getY(), y);
                return true;
            }

            public boolean onDoubleTap(MotionEvent e) {
                float toY;
                float fromY;
                float toX;
                float fromX;
                float targetScale;
                TouchPoint eventPoint = new TouchPoint(e.getX(), e.getY());
                if (TouchManager.this.scale == TouchManager.this.minimumScale) {
                    targetScale = TouchManager.this.maximumScale / 2.0f;
                    TouchPoint translatedTargetPosition = TouchManager.this.mapTouchCoordinateToMatrix(eventPoint, targetScale);
                    TouchPoint centeredTargetPosition = this.centerCoordinates(translatedTargetPosition);
                    fromX = TouchManager.this.position.getX();
                    toX = centeredTargetPosition.getX();
                    fromY = TouchManager.this.position.getY();
                    toY = centeredTargetPosition.getY();
                } else {
                    targetScale = TouchManager.this.minimumScale;
                    TouchPoint translatedPosition = TouchManager.this.mapTouchCoordinateToMatrix(eventPoint, TouchManager.this.scale);
                    TouchPoint centeredTargetPosition = this.centerCoordinates(translatedPosition);
                    fromX = centeredTargetPosition.getX();
                    toX = 0.0f;
                    fromY = centeredTargetPosition.getY();
                    toY = 0.0f;
                }
                TouchManager.this.gestureAnimator.animateDoubleTap(fromX, toX, fromY, toY, TouchManager.this.scale, targetScale);
                return true;
            }

            private TouchPoint centerCoordinates(TouchPoint coordinates) {
                float x = coordinates.getX() + (float)((TouchManager)TouchManager.this).imageBounds.right / 2.0f;
                float y = coordinates.getY() + (float)((TouchManager)TouchManager.this).imageBounds.bottom / 2.0f;
                return new TouchPoint(x, y);
            }
        });
        this.scaleGestureDetector.setQuickScaleEnabled(true);
        this.cropViewConfig = cropViewConfig;
        this.minimumScale = cropViewConfig.getMinScale();
        this.maximumScale = cropViewConfig.getMaxScale();
    }

    @TargetApi(value=8)
    public void onEvent(MotionEvent event) {
        this.scaleGestureDetector.onTouchEvent(event);
        this.gestureDetector.onTouchEvent(event);
        if (TouchManager.isUpAction(event.getActionMasked())) {
            this.ensureInsideViewport();
        }
    }

    public void applyPositioningAndScale(Matrix matrix) {
        matrix.postTranslate((float)(-this.bitmapWidth) / 2.0f, (float)(-this.bitmapHeight) / 2.0f);
        matrix.postScale(this.scale, this.scale);
        matrix.postTranslate(this.position.getX(), this.position.getY());
    }

    public void resetFor(int bitmapWidth, int bitmapHeight, int availableWidth, int availableHeight) {
        this.aspectRatio = this.cropViewConfig.getViewportRatio();
        this.imageBounds = new Rect(0, 0, availableWidth / 2, availableHeight / 2);
        this.setViewport(bitmapWidth, bitmapHeight, availableWidth, availableHeight);
        this.bitmapWidth = bitmapWidth;
        this.bitmapHeight = bitmapHeight;
        if (bitmapWidth > 0 && bitmapHeight > 0) {
            this.setMinimumScale();
            this.setLimits();
            this.resetPosition();
            this.ensureInsideViewport();
        }
    }

    public int getViewportWidth() {
        return this.viewportWidth;
    }

    public int getViewportHeight() {
        return this.viewportHeight;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(float ratio) {
        this.aspectRatio = ratio;
        this.cropViewConfig.setViewportRatio(ratio);
    }

    private TouchPoint mapTouchCoordinateToMatrix(TouchPoint coordinate, float targetScale) {
        float width = (float)this.bitmapWidth * targetScale;
        float height = (float)this.bitmapHeight * targetScale;
        float x0 = width / 2.0f;
        float y0 = height / 2.0f;
        float newX = coordinate.getX() * targetScale;
        newX = -(newX - x0);
        float newY = coordinate.getY() * targetScale;
        newY = newY > y0 ? -(newY - y0) : y0 - newY;
        return new TouchPoint(newX, newY);
    }

    private void ensureInsideViewport() {
        if (this.imageBounds == null) {
            return;
        }
        int bottom = this.imageBounds.bottom;
        float newY = this.position.getY();
        if ((float)bottom - newY >= (float)this.verticalLimit) {
            newY = bottom - this.verticalLimit;
        } else if (newY - (float)bottom >= (float)this.verticalLimit) {
            newY = bottom + this.verticalLimit;
        }
        float newX = this.position.getX();
        int right = this.imageBounds.right;
        if (newX <= (float)(right - this.horizontalLimit)) {
            newX = right - this.horizontalLimit;
        } else if (newX > (float)(right + this.horizontalLimit)) {
            newX = right + this.horizontalLimit;
        }
        this.position.set(newX, newY);
    }

    private void setViewport(int bitmapWidth, int bitmapHeight, int availableWidth, int availableHeight) {
        float imageAspect = (float)bitmapWidth / (float)bitmapHeight;
        float viewAspect = (float)availableWidth / (float)availableHeight;
        float ratio = this.cropViewConfig.getViewportRatio();
        if (Float.compare(0.0f, ratio) == 0) {
            ratio = imageAspect;
        }
        if (ratio > viewAspect) {
            this.viewportWidth = availableWidth - this.cropViewConfig.getViewportOverlayPadding() * 2;
            this.viewportHeight = (int)((float)this.viewportWidth * (1.0f / ratio));
        } else {
            this.viewportHeight = availableHeight - this.cropViewConfig.getViewportOverlayPadding() * 2;
            this.viewportWidth = (int)((float)this.viewportHeight * ratio);
        }
    }

    private void setLimits() {
        this.horizontalLimit = TouchManager.computeLimit((int)((float)this.bitmapWidth * this.scale), this.viewportWidth);
        this.verticalLimit = TouchManager.computeLimit((int)((float)this.bitmapHeight * this.scale), this.viewportHeight);
    }

    private void resetPosition() {
        this.position.set(this.imageBounds.right, this.imageBounds.bottom);
    }

    private void setMinimumScale() {
        float fw = (float)this.viewportWidth / (float)this.bitmapWidth;
        float fh = (float)this.viewportHeight / (float)this.bitmapHeight;
        this.minimumScale = Math.max(fw, fh);
        this.scale = Math.max(this.scale, this.minimumScale);
    }

    private float calculateScale(float newScaleDelta) {
        return Math.max(this.minimumScale, Math.min(this.scale * newScaleDelta, this.maximumScale));
    }

    private static int computeLimit(int bitmapSize, int viewportSize) {
        return (bitmapSize - viewportSize) / 2;
    }

    private static boolean isUpAction(int actionMasked) {
        return actionMasked == 6 || actionMasked == 1;
    }

    private static class GestureAnimator {
        public static final int ANIMATION_X = 0;
        public static final int ANIMATION_Y = 1;
        public static final int ANIMATION_SCALE = 2;
        private ValueAnimator xAnimator;
        private ValueAnimator yAnimator;
        private ValueAnimator scaleAnimator;
        private AnimatorSet animator;
        private final OnAnimationUpdateListener listener;
        final ValueAnimator.AnimatorUpdateListener updateListener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float val = ((Float)animation.getAnimatedValue()).floatValue();
                if (animation == xAnimator) {
                    listener.onAnimationUpdate(0, val);
                } else if (animation == yAnimator) {
                    listener.onAnimationUpdate(1, val);
                } else if (animation == scaleAnimator) {
                    listener.onAnimationUpdate(2, val);
                }
            }
        };
        private final Animator.AnimatorListener animatorListener = new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (xAnimator != null) {
                    xAnimator.removeUpdateListener(updateListener);
                }
                if (yAnimator != null) {
                    yAnimator.removeUpdateListener(updateListener);
                }
                if (scaleAnimator != null) {
                    scaleAnimator.removeUpdateListener(updateListener);
                }
                animator.removeAllListeners();
                listener.onAnimationFinished();
            }
        };

        public GestureAnimator(OnAnimationUpdateListener listener) {
            this.listener = listener;
        }

        public void animateTranslation(float fromX, float toX, float fromY, float toY) {
            if (this.animator != null) {
                this.animator.cancel();
            }
            this.xAnimator = ValueAnimator.ofFloat((float[])new float[]{fromX, toX});
            this.yAnimator = ValueAnimator.ofFloat((float[])new float[]{fromY, toY});
            this.scaleAnimator = null;
            this.xAnimator.addUpdateListener(this.updateListener);
            this.yAnimator.addUpdateListener(this.updateListener);
            this.animate((Interpolator)new DecelerateInterpolator(), 250L, this.xAnimator, this.yAnimator);
        }

        public void animateDoubleTap(float fromX, float toX, float fromY, float toY, float fromScale, float toScale) {
            if (this.animator != null) {
                this.animator.cancel();
            }
            this.xAnimator = ValueAnimator.ofFloat((float[])new float[]{fromX, toX});
            this.yAnimator = ValueAnimator.ofFloat((float[])new float[]{fromY, toY});
            this.scaleAnimator = ValueAnimator.ofFloat((float[])new float[]{fromScale, toScale});
            this.xAnimator.addUpdateListener(this.updateListener);
            this.yAnimator.addUpdateListener(this.updateListener);
            this.scaleAnimator.addUpdateListener(this.updateListener);
            this.animate((Interpolator)new AccelerateDecelerateInterpolator(), 500L, this.scaleAnimator, this.xAnimator, this.yAnimator);
        }

        private void animate(Interpolator interpolator, long duration, ValueAnimator first, ValueAnimator ... animators) {
            this.animator = new AnimatorSet();
            this.animator.setDuration(duration);
            this.animator.setInterpolator((TimeInterpolator)interpolator);
            this.animator.addListener(this.animatorListener);
            AnimatorSet.Builder builder = this.animator.play((Animator)first);
            for (ValueAnimator valueAnimator : animators) {
                builder.with((Animator)valueAnimator);
            }
            this.animator.start();
        }

        static interface OnAnimationUpdateListener {
            public void onAnimationUpdate(int var1, float var2);

            public void onAnimationFinished();
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AnimationType {
        }
    }
}

