/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.android.scissors;

import android.content.Context;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.request.RequestOptions;
import com.lyft.android.scissors.BitmapLoader;
import com.lyft.android.scissors.CropView;
import com.lyft.android.scissors.GlideFillViewportTransformation;

public class GlideBitmapLoader
implements BitmapLoader {
    private final RequestManager requestManager;
    private final BitmapTransformation transformation;

    public GlideBitmapLoader(@NonNull RequestManager requestManager, @NonNull BitmapTransformation transformation) {
        this.requestManager = requestManager;
        this.transformation = transformation;
    }

    @Override
    public void load(@Nullable Object model, @NonNull ImageView imageView) {
        RequestOptions requestOptions = new RequestOptions();
        this.requestManager.asBitmap().load(model).apply(((RequestOptions)((RequestOptions)requestOptions.skipMemoryCache(true)).diskCacheStrategy(DiskCacheStrategy.DATA)).transform((Transformation)this.transformation));
    }

    public static BitmapLoader createUsing(@NonNull CropView cropView) {
        return GlideBitmapLoader.createUsing(cropView, Glide.with((Context)cropView.getContext()));
    }

    public static BitmapLoader createUsing(@NonNull CropView cropView, @NonNull RequestManager requestManager) {
        return new GlideBitmapLoader(requestManager, GlideFillViewportTransformation.createUsing(cropView.getViewportWidth(), cropView.getViewportHeight()));
    }
}

