/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.android.scissors;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.eygraber.scissors.R;

class CropViewConfig {
    public static final float DEFAULT_VIEWPORT_RATIO = 0.0f;
    public static final float DEFAULT_MAXIMUM_SCALE = 10.0f;
    public static final float DEFAULT_MINIMUM_SCALE = 0.0f;
    public static final int DEFAULT_IMAGE_QUALITY = 100;
    public static final int DEFAULT_VIEWPORT_OVERLAY_PADDING = 0;
    public static final int DEFAULT_VIEWPORT_OVERLAY_COLOR = -939524096;
    public static final int DEFAULT_SHAPE = 0;
    private float viewportRatio = 0.0f;
    private float maxScale = 10.0f;
    private float minScale = 0.0f;
    private int viewportOverlayPadding = 0;
    private int viewportOverlayColor = -939524096;
    private int shape = 0;

    CropViewConfig() {
    }

    public int getViewportOverlayColor() {
        return this.viewportOverlayColor;
    }

    void setViewportOverlayColor(int viewportOverlayColor) {
        this.viewportOverlayColor = viewportOverlayColor;
    }

    public int getViewportOverlayPadding() {
        return this.viewportOverlayPadding;
    }

    void setViewportOverlayPadding(int viewportOverlayPadding) {
        this.viewportOverlayPadding = viewportOverlayPadding;
    }

    public float getViewportRatio() {
        return this.viewportRatio;
    }

    void setViewportRatio(float viewportRatio) {
        this.viewportRatio = viewportRatio <= 0.0f ? 0.0f : viewportRatio;
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    void setMaxScale(float maxScale) {
        this.maxScale = maxScale <= 0.0f ? 10.0f : maxScale;
    }

    public float getMinScale() {
        return this.minScale;
    }

    void setMinScale(float minScale) {
        this.minScale = minScale <= 0.0f ? 0.0f : minScale;
    }

    public int shape() {
        return this.shape;
    }

    public void setShape(int shape) {
        this.shape = shape;
    }

    public static CropViewConfig from(Context context, AttributeSet attrs) {
        CropViewConfig cropViewConfig = new CropViewConfig();
        if (attrs == null) {
            return cropViewConfig;
        }
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.CropView);
        cropViewConfig.setViewportRatio(attributes.getFloat(R.styleable.CropView_cropviewViewportRatio, 0.0f));
        cropViewConfig.setMaxScale(attributes.getFloat(R.styleable.CropView_cropviewMaxScale, 10.0f));
        cropViewConfig.setMinScale(attributes.getFloat(R.styleable.CropView_cropviewMinScale, 0.0f));
        cropViewConfig.setViewportOverlayColor(attributes.getColor(R.styleable.CropView_cropviewViewportOverlayColor, -939524096));
        cropViewConfig.setViewportOverlayPadding(attributes.getDimensionPixelSize(R.styleable.CropView_cropviewViewportOverlayPadding, 0));
        int shape = attributes.getInt(R.styleable.CropView_cropviewShape, 0);
        cropViewConfig.setShape(shape);
        attributes.recycle();
        return cropViewConfig;
    }
}

