/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.jsonrpc;

import com.exasol.bucketfs.jsonrpc.JsonMapper;
import com.exasol.bucketfs.jsonrpc.JsonRpcClient;
import com.exasol.bucketfs.jsonrpc.RpcCommand;
import jakarta.json.JsonObject;
import jakarta.json.bind.annotation.JsonbProperty;
import java.util.Objects;

class JsonRpcCommandExecutor {
    private final JsonRpcClient client;
    private final JsonMapper jsonMapper;

    JsonRpcCommandExecutor(JsonRpcClient client, JsonMapper jsonMapper) {
        this.client = Objects.requireNonNull(client, "client");
        this.jsonMapper = Objects.requireNonNull(jsonMapper, "jsonMapper");
    }

    <R> R execute(RpcCommand<R> command) {
        Object parameters = command.getParameters();
        JsonObject jsonObjectParam = this.jsonMapper.toJsonObject(parameters);
        String responseBody = this.client.sendRequest(new JsonRpcPayload("job_exec", command.getJobName(), jsonObjectParam));
        return command.processResult(responseBody);
    }

    public static class Parameters {
        @JsonbProperty(value="params")
        private final JsonObject params;

        private Parameters(JsonObject params) {
            this.params = params;
        }

        public JsonObject getParams() {
            return this.params;
        }
    }

    public static class JsonRpcPayload {
        @JsonbProperty(value="method")
        private final String method;
        @JsonbProperty(value="job")
        private final String job;
        @JsonbProperty(value="params")
        private final Parameters parameters;

        JsonRpcPayload(String method, String job, JsonObject parameters) {
            this.method = method;
            this.job = job;
            this.parameters = new Parameters(parameters);
        }

        public String getMethod() {
            return this.method;
        }

        public String getJob() {
            return this.job;
        }

        public Parameters getParameters() {
            return this.parameters;
        }
    }
}

