/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.jsonrpc;

import com.exasol.bucketfs.jsonrpc.Authenticator;
import com.exasol.bucketfs.jsonrpc.JsonMapper;
import com.exasol.bucketfs.jsonrpc.JsonRpcCommandExecutor;
import com.exasol.bucketfs.jsonrpc.JsonRpcException;
import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.logging.Logger;

class JsonRpcClient {
    private static final Logger LOGGER = Logger.getLogger(JsonRpcClient.class.getName());
    private final HttpClient httpClient;
    private final JsonMapper serializer;
    private final Authenticator authenticator;
    private final URI serviceUri;

    JsonRpcClient(HttpClient httpClient, JsonMapper serializer, Authenticator authenticator, URI serviceUri) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient");
        this.serializer = Objects.requireNonNull(serializer, "serializer");
        this.authenticator = Objects.requireNonNull(authenticator, "authenticator");
        this.serviceUri = Objects.requireNonNull(serviceUri, "serviceUri");
    }

    String sendRequest(JsonRpcCommandExecutor.JsonRpcPayload payload) {
        HttpRequest request = this.buildRequest(payload);
        Instant start = Instant.now();
        HttpResponse<String> response = this.sendRequest(request);
        this.verifySuccessResponse(request, response);
        String responseBody = response.body();
        LOGGER.finest(() -> "Received response " + response + " for request " + request + " with body '" + responseBody + "' after " + Duration.between(start, Instant.now()));
        return responseBody;
    }

    private HttpRequest buildRequest(JsonRpcCommandExecutor.JsonRpcPayload payload) {
        String requestBody = this.serializer.serialize(payload);
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(this.serviceUri).POST(HttpRequest.BodyPublishers.ofString(requestBody));
        this.authenticator.authenticate(requestBuilder);
        HttpRequest request = requestBuilder.build();
        LOGGER.finest(() -> "Sending request " + request + " with body '" + requestBody + "'");
        return request;
    }

    private void verifySuccessResponse(HttpRequest request, HttpResponse<String> response) {
        if (this.hasErrorStatusCode(response)) {
            throw new JsonRpcException(ExaError.messageBuilder((String)"E-BFSJ-22").message("RPC request {{request}} failed with response code {{responseCode}}. Response body was {{responseBody}}", new Object[]{request, response.statusCode(), response.body()}).toString());
        }
    }

    private boolean hasErrorStatusCode(HttpResponse<String> response) {
        return response.statusCode() / 100 != 2;
    }

    private HttpResponse<String> sendRequest(HttpRequest request) {
        try {
            return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException exception) {
            throw new JsonRpcException(ExaError.messageBuilder((String)"E-BFSJ-23").message("Unable to execute RPC request {{request}}", new Object[]{request}).toString(), exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-BFSJ-24").message("Interrupted when sending RPC request {{request}}", new Object[]{request}).toString(), exception);
        }
    }
}

