/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs;

import com.exasol.bucketfs.BucketAccessException;
import com.exasol.bucketfs.BucketOperation;
import com.exasol.errorreporting.ExaError;
import java.net.URI;

public class HttpResponseEvaluator {
    private HttpResponseEvaluator() {
    }

    public static void evaluate(URI uri, BucketOperation operation, int statusCode) throws BucketAccessException {
        switch (statusCode) {
            case 200: {
                return;
            }
            case 404: {
                throw new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-2").message("File or directory not found trying to {{operation|uq}} {{URI}}.", new Object[]{operation, uri}).toString());
            }
            case 403: {
                throw new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-3").message("Access denied trying to {{operation|uq}} {{URI}}.", new Object[]{operation, uri}).toString());
            }
        }
        throw new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-1").message("Unable to perform {{operation|uq}} {{URI}}. HTTP status {{status}}.", new Object[]{operation, uri, statusCode}).toString());
    }
}

