/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class CircleScaleIndicator
extends IndicatorDrawable {
    private final String TAG = CircleScaleIndicator.class.getSimpleName();
    private final int mCount = 4;
    private float space;
    private float radius;
    private float leftPadding;
    private float[] mAnimatedValue = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public CircleScaleIndicator(Context context, int indicatorColor, int indicatorSpeed) {
        Log.d((String)this.TAG, (String)"CircleScaleIndicator: ");
        this.indicatorColor = indicatorColor;
        this.indicatorSpeed = indicatorSpeed;
        if (indicatorSpeed <= 0) {
            this.indicatorSpeed = 1000;
        }
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(CircleScaleIndicator.dip2px(context, 1.0f));
        this.mPaint.setColor(this.indicatorColor);
        this.space = CircleScaleIndicator.dip2px(context, 2.0f);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        int[] delay = new int[]{100, 200, 300, 400};
        ArrayList<Animator> list = new ArrayList<Animator>();
        for (int i = 0; i < 4; ++i) {
            final int index = i;
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    ((CircleScaleIndicator)CircleScaleIndicator.this).mAnimatedValue[index] = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    CircleScaleIndicator.this.invalidateSelf();
                }
            });
            valueAnimator.setRepeatCount(-1);
            valueAnimator.setDuration((long)this.indicatorSpeed);
            valueAnimator.setStartDelay((long)delay[i]);
            list.add((Animator)valueAnimator);
        }
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        if (this.leftPadding == 0.0f) {
            this.radius = this.getWidth() / 20;
            this.leftPadding = ((float)this.getWidth() - this.radius * 2.0f * 4.0f + this.space * 3.0f) / 2.0f;
        }
        for (int i = 0; i < 4; ++i) {
            canvas.save();
            float translateX = this.leftPadding + this.radius * (float)((i + 1) * 2 - 1) + this.space * (float)i;
            canvas.translate(translateX, (float)(this.getHeight() / 2));
            canvas.scale(this.mAnimatedValue[i], this.mAnimatedValue[i]);
            canvas.drawCircle(0.0f, 0.0f, this.radius, paint);
            canvas.restore();
        }
    }
}

