/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.util.Log;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class CircleRotateIndicator
extends IndicatorDrawable {
    private final String TAG = CircleRotateIndicator.class.getSimpleName();
    private float rotateX = 0.0f;
    private float rotateY = 0.0f;
    private Camera mCamera;
    private Matrix mMatrix;

    public CircleRotateIndicator(Context context, int indicatorColor, int indicatorSpeed) {
        Log.d((String)this.TAG, (String)"CircleRotateIndicator: ");
        this.indicatorColor = indicatorColor;
        this.indicatorSpeed = indicatorSpeed;
        if (indicatorSpeed <= 0) {
            this.indicatorSpeed = 3000;
        }
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mCamera = new Camera();
        this.mMatrix = new Matrix();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(CircleRotateIndicator.dip2px(context, 1.0f));
        this.mPaint.setColor(this.indicatorColor);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        ArrayList<Animator> list = new ArrayList<Animator>();
        ValueAnimator valueAnimatorX = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
        valueAnimatorX.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                CircleRotateIndicator.this.rotateX = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                CircleRotateIndicator.this.invalidateSelf();
            }
        });
        valueAnimatorX.setRepeatCount(-1);
        valueAnimatorX.setDuration((long)this.indicatorSpeed);
        list.add((Animator)valueAnimatorX);
        ValueAnimator valueAnimatorY = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
        valueAnimatorY.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                CircleRotateIndicator.this.rotateY = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                CircleRotateIndicator.this.invalidateSelf();
            }
        });
        valueAnimatorY.setRepeatCount(-1);
        valueAnimatorY.setDuration((long)(this.indicatorSpeed / 3));
        list.add((Animator)valueAnimatorY);
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        this.mMatrix.reset();
        this.mCamera.save();
        this.mCamera.rotateX(this.rotateX);
        this.mCamera.rotateY(this.rotateY);
        this.mCamera.getMatrix(this.mMatrix);
        this.mCamera.restore();
        float centerX = this.getWidth() / 2;
        float centerY = this.getHeight() / 2;
        this.mMatrix.preTranslate(-centerX, -centerY);
        this.mMatrix.postTranslate(centerX, centerY);
        canvas.concat(this.mMatrix);
        float radius = this.getWidth() / 10;
        canvas.drawCircle(centerX, centerY, radius, paint);
    }
}

