/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class CircleCollisionIndicator
extends IndicatorDrawable {
    private final String TAG = CircleCollisionIndicator.class.getSimpleName();
    private final int mCount = 4;
    private float leftBallMoveXOffset = 0.0f;
    private float rightBallMoveXOffset = 0.0f;
    private float maxMoveXOffset;
    private Interpolator mAccelerateInterpolator = new AccelerateInterpolator();
    private Interpolator mDecelerateInterpolator = new DecelerateInterpolator();
    private static final float DEFAULT_BALL_RADIUS = 5.0f;
    private static final float MAX_MOVE_OFFSET = 50.0f;

    public CircleCollisionIndicator(Context context, int indicatorColor, int indicatorSpeed) {
        Log.d((String)this.TAG, (String)"CircleCollisionIndicator: ");
        this.indicatorColor = indicatorColor;
        this.indicatorSpeed = indicatorSpeed;
        if (indicatorSpeed <= 0) {
            this.indicatorSpeed = 2000;
        }
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(CircleCollisionIndicator.dip2px(context, 1.0f));
        this.mPaint.setColor(this.indicatorColor);
        this.maxMoveXOffset = CircleCollisionIndicator.dip2px(context, 30.0f);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        ArrayList<Animator> list = new ArrayList<Animator>();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                CircleCollisionIndicator.this.compute(((Float)valueAnimator.getAnimatedValue()).floatValue());
                CircleCollisionIndicator.this.invalidateSelf();
            }
        });
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator.setRepeatCount(-1);
        valueAnimator.setDuration((long)this.indicatorSpeed);
        list.add((Animator)valueAnimator);
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        canvas.save();
        this.drawBall(canvas, paint);
        canvas.restore();
    }

    private void drawBall(Canvas canvas, Paint paint) {
        float radius = this.getWidth() / 25;
        float ballOffsetX = ((float)this.getWidth() - 2.0f * radius * 2.0f) / 2.0f;
        float ballCenterY = this.getHeight() / 2;
        for (int i = 1; i < 3; ++i) {
            canvas.drawCircle(ballOffsetX + radius * (float)(i * 2 - 1), ballCenterY, radius, paint);
        }
        canvas.drawCircle(ballOffsetX - radius - this.leftBallMoveXOffset, ballCenterY, radius, paint);
        canvas.drawCircle(ballOffsetX + 2.0f * radius * 2.0f + radius + this.rightBallMoveXOffset, ballCenterY, radius, paint);
    }

    private void compute(float progress) {
        if (progress <= 0.25f) {
            this.rightBallMoveXOffset = 0.0f;
            this.computeLeft(progress);
        } else if (progress <= 0.5f) {
            this.rightBallMoveXOffset = 0.0f;
            this.computeLeft(0.5f - progress);
        } else if (progress <= 0.75f) {
            this.leftBallMoveXOffset = 0.0f;
            this.computeRight(progress - 0.5f);
        } else if (progress <= 1.0f) {
            this.leftBallMoveXOffset = 0.0f;
            this.computeRight(1.0f - progress);
        }
    }

    private void computeLeft(float progress) {
        this.rightBallMoveXOffset = 0.0f;
        this.leftBallMoveXOffset = progress * this.maxMoveXOffset;
    }

    private void computeRight(float progress) {
        this.leftBallMoveXOffset = 0.0f;
        this.rightBallMoveXOffset = progress * this.maxMoveXOffset;
    }
}

