/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class ArcRotateScaleIndicator
extends IndicatorDrawable {
    private final String TAG = ArcRotateScaleIndicator.class.getSimpleName();
    private float radius;
    private RectF mRectF;
    private float mScaleValue;
    private float mRotateValue;

    public ArcRotateScaleIndicator(Context context, int indicatorColor, int indicatorSpeed) {
        Log.d((String)this.TAG, (String)"ArcRotateScaleIndicator: ");
        this.indicatorColor = indicatorColor;
        this.indicatorSpeed = indicatorSpeed;
        if (indicatorSpeed <= 0) {
            this.indicatorSpeed = 2000;
        }
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(ArcRotateScaleIndicator.dip2px(context, 1.0f));
        this.mPaint.setColor(this.indicatorColor);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setDither(true);
        this.radius = ArcRotateScaleIndicator.dip2px(context, 10.0f);
    }

    @Override
    protected ArrayList<Animator> getAnimation() {
        ArrayList<Animator> list = new ArrayList<Animator>();
        ValueAnimator scaleAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.5f, 1.0f});
        scaleAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ArcRotateScaleIndicator.this.mScaleValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                ArcRotateScaleIndicator.this.invalidateSelf();
            }
        });
        scaleAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        scaleAnimator.setRepeatCount(-1);
        scaleAnimator.setDuration((long)this.indicatorSpeed);
        ValueAnimator rotateAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 180.0f, 360.0f});
        rotateAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ArcRotateScaleIndicator.this.mRotateValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                ArcRotateScaleIndicator.this.invalidateSelf();
            }
        });
        rotateAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        rotateAnimator.setRepeatCount(-1);
        rotateAnimator.setDuration((long)(this.indicatorSpeed / 2));
        list.add((Animator)scaleAnimator);
        list.add((Animator)rotateAnimator);
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        if (this.mRectF == null) {
            this.mRectF = new RectF();
            this.mRectF.set(-this.radius, -this.radius, this.radius, this.radius);
        }
        canvas.save();
        float x = this.getWidth() / 2;
        float y = this.getHeight() / 2;
        canvas.translate(x, y);
        canvas.scale(this.mScaleValue, this.mScaleValue);
        canvas.rotate(this.mRotateValue);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawArc(this.mRectF, 225.0f, 90.0f, false, paint);
        canvas.drawArc(this.mRectF, 45.0f, 90.0f, false, paint);
        canvas.restore();
    }
}

