/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Star;

import android.graphics.RectF;
import com.example.mzy.indicators.Star.VertexF;

class StarModel {
    private static final String TAG = "StarModel";
    public static final float DEFAULT_THICKNESS = 0.5f;
    public static final float MIN_THICKNESS = 0.3f;
    public static final float MAX_THICKNESS = 0.9f;
    public static final float DEFAULT_SCALE_FACTOR = 0.9511f;
    private float currentScaleFactor = 0.9511f;
    private RectF outerRect = new RectF();
    private float currentThicknessFactor = 0.5f;
    private static final float[] starVertexes = new float[]{-0.9511f, 0.309f, 0.0f, 1.0f, 0.9511f, 0.309f, 0.5878f, -0.809f, -0.5878f, -0.809f};
    private static final float aspectRatio = (starVertexes[3] - starVertexes[7]) / (starVertexes[4] - starVertexes[0]);
    private VertexF firstVertex;
    private VertexF[] vertexes;

    public StarModel(float thicknessFactor) {
        this.reset(thicknessFactor);
    }

    public StarModel() {
        this(0.5f);
    }

    private void reset(float thickness) {
        this.currentScaleFactor = 0.9511f;
        this.initAllVertexesToStandard();
        this.updateOuterRect();
        this.setThicknessOnStandardCoordinate(thickness);
        this.adjustCoordinate();
    }

    public void setDrawingOuterRect(float left, float top, float height) {
        float resizeFactor = height / aspectRatio;
        this.offsetStar(-this.outerRect.left, -this.outerRect.top);
        this.changeScaleFactor(resizeFactor);
        this.offsetStar(left, top);
        this.updateOuterRect();
    }

    public void moveStarTo(float left, float top) {
        float offsetX = left - this.outerRect.left;
        float offsetY = left - this.outerRect.top;
        this.offsetStar(offsetX, offsetY);
        this.updateOuterRect();
    }

    private void initAllVertexesToStandard() {
        if (this.firstVertex == null) {
            this.firstVertex = new VertexF(starVertexes[0], starVertexes[1]);
        } else {
            this.firstVertex.x = starVertexes[0];
            this.firstVertex.y = starVertexes[1];
        }
        if (this.vertexes == null) {
            this.vertexes = new VertexF[10];
            this.vertexes[0] = this.firstVertex;
            for (int i = 1; i < 10; ++i) {
                this.vertexes[i] = new VertexF();
                this.vertexes[i - 1].next = this.vertexes[i];
            }
            this.vertexes[9].next = this.vertexes[0];
        }
        VertexF current = this.firstVertex;
        for (int i = 0; i < 5; ++i) {
            current.x = starVertexes[i * 2];
            current.y = starVertexes[i * 2 + 1];
            current = current.next.next;
        }
        VertexF prevOuter = this.firstVertex;
        for (int i = 0; i < 5; ++i) {
            VertexF innerV = prevOuter.next;
            innerV.x = (prevOuter.x + innerV.next.x) / 2.0f;
            innerV.y = (prevOuter.y + innerV.next.y) / 2.0f;
            prevOuter = innerV.next;
        }
    }

    public VertexF getVertex(int index) {
        return this.vertexes[index];
    }

    public RectF getOuterRect() {
        return new RectF(this.outerRect);
    }

    private void updateOuterRect() {
        this.outerRect.top = this.vertexes[2].y;
        this.outerRect.right = this.vertexes[4].x;
        this.outerRect.bottom = this.vertexes[8].y;
        this.outerRect.left = this.vertexes[0].x;
    }

    private void offsetStar(float left, float top) {
        for (int i = 0; i < this.vertexes.length; ++i) {
            this.vertexes[i].x += left;
            this.vertexes[i].y += top;
        }
    }

    private void changeScaleFactor(float newFactor) {
        float scale = newFactor / this.currentScaleFactor;
        if (scale == 1.0f) {
            return;
        }
        for (int i = 0; i < this.vertexes.length; ++i) {
            this.vertexes[i].x *= scale;
            this.vertexes[i].y *= scale;
        }
        this.currentScaleFactor = newFactor;
    }

    public void setThickness(float factor) {
        if (this.currentThicknessFactor == factor) {
            return;
        }
        float oldScale = this.currentScaleFactor;
        float left = this.outerRect.left;
        float top = this.outerRect.top;
        this.reset(factor);
        this.changeScaleFactor(oldScale);
        this.moveStarTo(left, top);
    }

    private void setThicknessOnStandardCoordinate(float thicknessFactor) {
        if (thicknessFactor < 0.3f) {
            thicknessFactor = 0.3f;
        } else if (thicknessFactor > 0.9f) {
            thicknessFactor = 0.9f;
        }
        for (int i = 1; i < this.vertexes.length; i += 2) {
            this.vertexes[i].x *= thicknessFactor;
            this.vertexes[i].y *= thicknessFactor;
        }
        this.currentThicknessFactor = thicknessFactor;
    }

    private void adjustCoordinate() {
        float offsetX = -this.outerRect.left;
        float offsetY = this.outerRect.top;
        for (int i = 0; i < this.vertexes.length; ++i) {
            this.vertexes[i].y = -this.vertexes[i].y + offsetY;
            this.vertexes[i].x += offsetX;
            this.vertexes[i].x /= 2.0f;
            this.vertexes[i].y /= 2.0f;
        }
        this.updateOuterRect();
    }

    public static float getOuterRectAspectRatio() {
        return aspectRatio;
    }

    public static float getStarWidth(float starHeight) {
        return starHeight / StarModel.getOuterRectAspectRatio();
    }
}

