/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.state.lint.detector;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0016\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00170\u0014H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/evernote/android/state/lint/detector/AndroidStateDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "restoreCalls", "", "Lorg/jetbrains/uast/UDeclaration;", "Lorg/jetbrains/uast/UCallExpression;", "saveCalls", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableFiles", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "getApplicableMethodNames", "", "", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Issues", "android-state-lint"})
public final class AndroidStateDetector
extends Detector
implements Detector.UastScanner {
    private final Map<UDeclaration, UCallExpression> saveCalls;
    private final Map<UDeclaration, UCallExpression> restoreCalls;
    private static final Implementation IMPLEMENTATION;
    private static final String ADVICE = "StateSaver calls should always occur in pairs. StateSaver.saveInstanceState() should always have a matching call to StateSaver.restoreInstanceState().";
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final String SAVE_INSTANCE_STATE_METHOD = "saveInstanceState";
    private static final String RESTORE_INSTANCE_STATE_METHOD = "restoreInstanceState";
    private static final List<String> APPLICABLE_METHODS;
    private static final String STATE_SAVER_CLASS_SIMPLE = "StateSaver";
    private static final String STATE_SAVER_CLASS = "com.evernote.android.state.StateSaver";
    public static final Issues Issues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCheckFile(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            UDeclaration it;
            Iterable $receiver$iv$iv;
            Set set;
            if (!(context instanceof JavaContext)) {
                return;
            }
            Iterable $receiver = set = (Set)new LinkedHashSet();
            $receiver.addAll(this.saveCalls.keySet());
            $receiver.addAll(this.restoreCalls.keySet());
            Set allClasses = set;
            Iterable $receiver$iv = allClasses;
            $receiver = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (UDeclaration)element$iv$iv;
                if (!(this.saveCalls.containsKey(it) ^ this.restoreCalls.containsKey(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (UDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv;
                UCallExpression uCallExpression = this.saveCalls.get(it);
                if (uCallExpression == null) {
                    uCallExpression = this.restoreCalls.get(it);
                }
                if (uCallExpression == null) {
                    Intrinsics.throwNpe();
                }
                UCallExpression uCallExpression2 = uCallExpression;
                collection.add(uCallExpression2);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                UCallExpression it2 = (UCallExpression)element$iv;
                JavaContext.report$default((JavaContext)((JavaContext)context), (Issue)ISSUE, (UElement)((UElement)it2), (Location)((JavaContext)context).getLocation((UElement)it2), (String)ADVICE, null, (int)16, null);
            }
        }
        finally {
            this.saveCalls.clear();
            this.restoreCalls.clear();
        }
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new UElementHandler(this){
            final /* synthetic */ AndroidStateDetector this$0;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitCallExpression(@NotNull UCallExpression node) {
                Map map;
                void $receiver$iv$iv;
                Iterable iterable;
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Object object = node.getMethodIdentifier();
                if (object == null || (object = object.getName()) == null) {
                    return;
                }
                Object methodName = object;
                UElement uElement = node.getUastParent();
                if (uElement == null) {
                    return;
                }
                UElement uastParent = uElement;
                if (!AndroidStateDetector.access$getAPPLICABLE_METHODS$cp().contains(methodName)) {
                    return;
                }
                UFile uFile = UastUtils.getContainingUFile((UElement)((UElement)node));
                if (uFile == null) {
                    return;
                }
                UFile uFile2 = uFile;
                Iterable iterable2 = iterable = (Iterable)uFile2.getImports();
                Collection destination$iv$iv = new ArrayList<E>();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                UCallExpression uCallExpression = $receiver$iv$iv$iv.iterator();
                while (uCallExpression.hasNext()) {
                    String string;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = uCallExpression.next();
                    UImportStatement it = (UImportStatement)element$iv$iv;
                    UElement uElement2 = it.getImportReference();
                    String string2 = uElement2 != null ? uElement2.asSourceString() : null;
                    if (string2 == null) continue;
                    String it$iv$iv = string = string2;
                    destination$iv$iv.add(it$iv$iv);
                }
                List imports = (List)destination$iv$iv;
                Object object2 = uastParent.getPsi();
                if (object2 == null || (object2 = object2.getText()) == null) {
                    return;
                }
                Object object3 = object2;
                if (!this.isStateSaverMethod((String)methodName, imports, (String)object3)) {
                    return;
                }
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
                if (uClass == null) {
                    Intrinsics.throwNpe();
                }
                UClass cls = uClass;
                Object object4 = methodName;
                switch (((String)object4).hashCode()) {
                    case -271628018: {
                        if (!((String)object4).equals("restoreInstanceState")) return;
                        break;
                    }
                    case 415651455: {
                        if (!((String)object4).equals("saveInstanceState")) return;
                        map = AndroidStateDetector.access$getSaveCalls$p(this.this$0);
                        uCallExpression = node;
                        map.put(cls, uCallExpression);
                        return;
                    }
                }
                map = AndroidStateDetector.access$getRestoreCalls$p(this.this$0);
                uCallExpression = node;
                map.put(cls, uCallExpression);
            }

            private final boolean isStateSaverMethod(String methodName, List<String> imports, String parent) {
                return imports.contains("com.evernote.android.state.StateSaver." + methodName) ? true : imports.contains("com.evernote.android.state.StateSaver") && StringsKt.startsWith$default((String)parent, (String)("StateSaver." + methodName), (boolean)false, (int)2, null);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @NotNull
    public EnumSet<Scope> getApplicableFiles() {
        return Scope.JAVA_FILE_SCOPE;
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return APPLICABLE_METHODS;
    }

    public AndroidStateDetector() {
        Map map;
        AndroidStateDetector androidStateDetector = this;
        androidStateDetector.saveCalls = map = (Map)new LinkedHashMap();
        androidStateDetector = this;
        androidStateDetector.restoreCalls = map = (Map)new LinkedHashMap();
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(AndroidStateDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create("NonMatchingStateSaverCalls", ADVICE, "StateSaver calls should always occur in pairs. StateSaver.saveInstanceState() should always have a matching call to StateSaver.restoreInstanceState(). Failing to do so could result in weird behaviors after activity recreation where certain states are not persisted.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
        APPLICABLE_METHODS = CollectionsKt.listOf((Object[])new String[]{SAVE_INSTANCE_STATE_METHOD, RESTORE_INSTANCE_STATE_METHOD});
    }

    @NotNull
    public static final /* synthetic */ List access$getAPPLICABLE_METHODS$cp() {
        return APPLICABLE_METHODS;
    }

    @NotNull
    public static final /* synthetic */ Map access$getSaveCalls$p(AndroidStateDetector $this) {
        return $this.saveCalls;
    }

    @NotNull
    public static final /* synthetic */ Map access$getRestoreCalls$p(AndroidStateDetector $this) {
        return $this.restoreCalls;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/evernote/android/state/lint/detector/AndroidStateDetector$Issues;", "", "()V", "ADVICE", "", "APPLICABLE_METHODS", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "RESTORE_INSTANCE_STATE_METHOD", "SAVE_INSTANCE_STATE_METHOD", "STATE_SAVER_CLASS", "STATE_SAVER_CLASS_SIMPLE", "android-state-lint"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

