/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.junit;

import com.epam.reportportal.annotations.UniqueID;
import com.epam.reportportal.junit.IListenerHandler;
import com.epam.reportportal.junit.ParallelRunningContext;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.google.inject.Inject;
import com.nordstrom.automation.junit.ArtifactParams;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.RetriedTest;
import io.reactivex.Maybe;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;
import rp.com.google.common.annotations.VisibleForTesting;
import rp.com.google.common.base.Function;
import rp.com.google.common.base.Strings;
import rp.com.google.common.base.Supplier;
import rp.com.google.common.base.Throwables;

public class ParallelRunningHandler
implements IListenerHandler {
    public static final String API_BASE = "/reportportal-ws/api/v1";
    private ParallelRunningContext context;
    private MemoizingSupplier<Launch> launch;

    @Inject
    public ParallelRunningHandler(ParallelRunningContext parallelRunningContext, ReportPortal reportPortalService) {
        this.context = parallelRunningContext;
        this.launch = new MemoizingSupplier(() -> {
            StartLaunchRQ rq = this.buildStartLaunchRq(reportPortalService.getParameters());
            return reportPortalService.newLaunch(rq);
        });
    }

    @Override
    public void startLaunch() {
        this.launch.get().start();
    }

    @Override
    public void stopLaunch() {
        FinishExecutionRQ finishExecutionRQ = new FinishExecutionRQ();
        finishExecutionRQ.setEndTime(Calendar.getInstance().getTime());
        this.launch.get().finish(finishExecutionRQ);
        this.launch.reset();
    }

    @Override
    public void startRunner(Object runner, boolean isSuite) {
        StartTestItemRQ rq = isSuite ? this.buildStartSuiteRq(runner) : this.buildStartTestItemRq(runner);
        Maybe<String> containerId = this.getContainerId(runner);
        Maybe itemId = containerId == null ? this.launch.get().startTestItem(rq) : this.launch.get().startTestItem(containerId, rq);
        this.context.setTestIdOfTestRunner(runner, (Maybe<String>)itemId);
    }

    @Override
    public void stopRunner(Object runner) {
        FinishTestItemRQ rq = this.buildFinishTestRq(null);
        this.launch.get().finishTestItem(this.context.getItemIdOfTestRunner(runner), rq);
    }

    @Override
    public void startTestMethod(FrameworkMethod method, Object runner) {
        StartTestItemRQ rq = this.buildStartStepRq(method);
        rq.setParameters(this.createStepParameters(method, runner));
        Maybe itemId = this.launch.get().startTestItem(this.context.getItemIdOfTestRunner(runner), rq);
        this.context.setItemIdOfTestMethod(method, runner, (Maybe<String>)itemId);
    }

    @Override
    public void stopTestMethod(FrameworkMethod method, Object runner) {
        String status = this.context.getStatusOfTestMethod(method, runner);
        FinishTestItemRQ rq = this.buildFinishStepRq(method, status);
        this.launch.get().finishTestItem(this.context.getItemIdOfTestMethod(method, runner), rq);
    }

    @Override
    public void markCurrentTestMethod(FrameworkMethod method, Object runner, String status) {
        this.context.setStatusOfTestMethod(method, runner, status);
    }

    @Override
    public void handleTestSkip(FrameworkMethod method, Object runner) {
        StartTestItemRQ startRQ = this.buildStartStepRq(method);
        Maybe itemId = this.launch.get().startTestItem(this.context.getItemIdOfTestRunner(runner), startRQ);
        FinishTestItemRQ finishRQ = this.buildFinishStepRq(method, "SKIPPED");
        this.launch.get().finishTestItem(itemId, finishRQ);
    }

    @Override
    public void sendReportPortalMsg(FrameworkMethod method, Object runner, Throwable thrown) {
        Function function = itemId -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setTestItemId(itemId);
            rq.setLevel("ERROR");
            rq.setLogTime(Calendar.getInstance().getTime());
            if (thrown != null) {
                rq.setMessage(Throwables.getStackTraceAsString((Throwable)thrown));
            } else {
                rq.setMessage("Test has failed without exception");
            }
            rq.setLogTime(Calendar.getInstance().getTime());
            return rq;
        };
        ReportPortal.emitLog((Function)function);
    }

    @Override
    public boolean isReportable(FrameworkMethod method) {
        return !this.detectMethodType(method).isEmpty();
    }

    private String detectMethodType(FrameworkMethod method) {
        if (null != method.getAnnotation(Test.class)) {
            return "STEP";
        }
        if (null != method.getAnnotation(Before.class)) {
            return "BEFORE_METHOD";
        }
        if (null != method.getAnnotation(After.class)) {
            return "AFTER_METHOD";
        }
        if (null != method.getAnnotation(BeforeClass.class)) {
            return "BEFORE_CLASS";
        }
        if (null != method.getAnnotation(AfterClass.class)) {
            return "AFTER_CLASS";
        }
        return "";
    }

    private Maybe<String> getContainerId(Object runner) {
        Object parent = LifecycleHooks.getParentOf((Object)runner);
        if (parent != null) {
            return this.context.getItemIdOfTestRunner(parent);
        }
        return null;
    }

    protected StartLaunchRQ buildStartLaunchRq(ListenerParameters parameters) {
        StartLaunchRQ rq = new StartLaunchRQ();
        rq.setName(parameters.getLaunchName());
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setTags(parameters.getTags());
        rq.setMode(parameters.getLaunchRunningMode());
        if (!Strings.isNullOrEmpty((String)parameters.getDescription())) {
            rq.setDescription(parameters.getDescription());
        }
        return rq;
    }

    protected StartTestItemRQ buildStartSuiteRq(Object runner) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(this.getName(runner));
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("SUITE");
        return rq;
    }

    protected StartTestItemRQ buildStartTestItemRq(Object runner) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(this.getName(runner));
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("TEST");
        return rq;
    }

    protected StartTestItemRQ buildStartStepRq(FrameworkMethod method) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(method.getName());
        rq.setDescription(this.createStepDescription(method));
        rq.setUniqueId(this.extractUniqueID(method));
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType(this.detectMethodType(method));
        rq.setRetry(Boolean.valueOf(this.isRetry(method)));
        return rq;
    }

    protected FinishTestItemRQ buildFinishSuiteRq(TestClass testClass) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(Calendar.getInstance().getTime());
        return rq;
    }

    protected FinishTestItemRQ buildFinishTestRq(TestClass testClass) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(Calendar.getInstance().getTime());
        return rq;
    }

    protected FinishTestItemRQ buildFinishStepRq(FrameworkMethod method, String status) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(Calendar.getInstance().getTime());
        rq.setStatus(status == null || status.equals("") ? "PASSED" : status);
        if ("SKIPPED".equals(status) && !((Boolean)rp.com.google.common.base.Optional.fromNullable((Object)this.launch.get().getParameters().getSkippedAnIssue()).or((Object)false)).booleanValue()) {
            Issue issue = new Issue();
            issue.setIssueType("NOT_ISSUE");
            rq.setIssue(issue);
        }
        return rq;
    }

    protected List<ParameterResource> createStepParameters(FrameworkMethod method, Object runner) {
        List<ParameterResource> parameters = this.createMethodParameters(method, runner);
        return parameters.isEmpty() ? null : parameters;
    }

    private List<ParameterResource> createMethodParameters(FrameworkMethod method, Object runner) {
        Optional params;
        Object target;
        ArrayList<ParameterResource> result = new ArrayList<ParameterResource>();
        if (!method.isStatic() && !this.isIgnored(method) && (target = LifecycleHooks.getTargetForRunner((Object)runner)) instanceof ArtifactParams && (params = ((ArtifactParams)target).getParameters()).isPresent()) {
            for (Map.Entry param : ((Map)params.get()).entrySet()) {
                ParameterResource parameter = new ParameterResource();
                parameter.setKey((String)param.getKey());
                parameter.setValue(Objects.toString(param.getValue(), null));
                result.add(parameter);
            }
        }
        return result;
    }

    protected String createStepDescription(FrameworkMethod method) {
        return method.getName();
    }

    private String extractUniqueID(FrameworkMethod method) {
        UniqueID itemUniqueID = (UniqueID)method.getAnnotation(UniqueID.class);
        return itemUniqueID != null ? itemUniqueID.value() : null;
    }

    private boolean isIgnored(FrameworkMethod method) {
        return null != method.getAnnotation(Ignore.class);
    }

    private boolean isRetry(FrameworkMethod method) {
        return null != method.getAnnotation(RetriedTest.class);
    }

    private String getName(Object runner) {
        String name;
        TestClass testClass = LifecycleHooks.getTestClassOf((Object)runner);
        Class javaClass = testClass.getJavaClass();
        if (javaClass != null) {
            name = javaClass.getName();
        } else {
            String role = null == LifecycleHooks.getParentOf((Object)runner) ? "Root " : "Context ";
            String type = runner instanceof Suite ? "Suite" : "Class";
            name = role + type + " Runner";
        }
        return name;
    }

    @VisibleForTesting
    static class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        transient T value;
        private static final long serialVersionUID = 0L;

        MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        Object t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return (T)t;
                    }
                }
            }
            return this.value;
        }

        public synchronized void reset() {
            this.initialized = false;
        }

        public String toString() {
            return "Suppliers.memoize(" + this.delegate + ")";
        }
    }
}

