/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.treecomparing;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class StreamUtils {
    public static Function<List<String>, String> joining(String delimiter, String lastDelimiter) {
        return list -> {
            int last = list.size() - 1;
            if (last < 1) {
                return String.join((CharSequence)delimiter, list);
            }
            return String.join((CharSequence)lastDelimiter, String.join((CharSequence)delimiter, list.subList(0, last)), (CharSequence)list.get(last));
        };
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static <T> Predicate<T> logFiltered(Predicate<T> predicate, Consumer<T> action) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(action);
        return value -> {
            if (predicate.test(value)) {
                return true;
            }
            action.accept(value);
            return false;
        };
    }

    private StreamUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

