/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.utils;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemUtils {
    private static final Logger log = LoggerFactory.getLogger((String)"healenium");

    public static String getHostProjectName() {
        String projectPath = System.getProperty("user.dir").replace("\\", "/");
        return projectPath.substring(projectPath.lastIndexOf("/") + 1);
    }

    public static String getHostIpAddress() {
        try {
            return Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            log.warn("Failed to get host address", (Throwable)ex);
            return "";
        }
    }

    public static String getMd5Hash(String locator, String command, String url) {
        String rawKey = url + command + locator.hashCode();
        log.debug("[Save Elements] RawKey: {}", (Object)rawKey);
        String key = DigestUtils.md5Hex((byte[])rawKey.trim().getBytes(StandardCharsets.UTF_8));
        log.debug("[Save Elements] SelectorId: {}", (Object)key);
        return key;
    }

    private SystemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

