/*
 * Decompiled with CFR 0.152.
 */
package com.epages.restdocs.apispec;

import com.epages.restdocs.apispec.DescriptorValidator;
import com.epages.restdocs.apispec.HeaderDescriptorWithType;
import com.epages.restdocs.apispec.ParameterDescriptorWithType;
import com.epages.restdocs.apispec.ResourceSnippet;
import com.epages.restdocs.apispec.ResourceSnippetParameters;
import com.epages.restdocs.apispec.Schema;
import com.epages.restdocs.apispec.SecurityRequirements;
import com.epages.restdocs.apispec.SecurityRequirementsHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.Closeable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.snippet.PlaceholderResolverFactory;
import org.springframework.restdocs.snippet.RestDocumentationContextPlaceholderResolverFactory;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.restdocs.snippet.StandardWriterResolver;
import org.springframework.restdocs.templates.TemplateFormat;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.util.UriComponents;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005\u001f !\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\n \u0007*\u0004\u0018\u00010\u00190\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\n \u0007*\u0004\u0018\u00010\u00150\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e*\b\u0012\u0004\u0012\u00020\u001c0\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/epages/restdocs/apispec/ResourceSnippet;", "Lorg/springframework/restdocs/snippet/Snippet;", "resourceSnippetParameters", "Lcom/epages/restdocs/apispec/ResourceSnippetParameters;", "(Lcom/epages/restdocs/apispec/ResourceSnippetParameters;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "propertyPlaceholderHelper", "Lorg/springframework/util/PropertyPlaceholderHelper;", "createModel", "Lcom/epages/restdocs/apispec/ResourceSnippet$ResourceModel;", "operation", "Lorg/springframework/restdocs/operation/Operation;", "placeholderResolverFactory", "Lorg/springframework/restdocs/snippet/PlaceholderResolverFactory;", "context", "Lorg/springframework/restdocs/RestDocumentationContext;", "document", "", "getContentTypeOrDefault", "", "headers", "Lorg/springframework/http/HttpHeaders;", "getUriComponents", "Lorg/springframework/web/util/UriComponents;", "getUriPath", "withExample", "Lcom/epages/restdocs/apispec/HeaderDescriptorWithType;", "withExampleValues", "", "JsonTemplateFormat", "MissingUrlTemplateException", "RequestModel", "ResourceModel", "ResponseModel", "restdocs-api-spec"})
public final class ResourceSnippet
implements Snippet {
    @NotNull
    private final ResourceSnippetParameters resourceSnippetParameters;
    private final ObjectMapper objectMapper;
    @NotNull
    private final PropertyPlaceholderHelper propertyPlaceholderHelper;

    public ResourceSnippet(@NotNull ResourceSnippetParameters resourceSnippetParameters) {
        Intrinsics.checkNotNullParameter((Object)resourceSnippetParameters, (String)"resourceSnippetParameters");
        this.resourceSnippetParameters = resourceSnippetParameters;
        this.objectMapper = ExtensionsKt.jacksonObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        this.propertyPlaceholderHelper = new PropertyPlaceholderHelper("{", "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void document(@NotNull Operation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Object v = operation.getAttributes().get(RestDocumentationContext.class.getName());
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type org.springframework.restdocs.RestDocumentationContext");
        RestDocumentationContext context = (RestDocumentationContext)v;
        DescriptorValidator.INSTANCE.validatePresentParameters(this.resourceSnippetParameters, operation);
        RestDocumentationContextPlaceholderResolverFactory placeholderResolverFactory = new RestDocumentationContextPlaceholderResolverFactory();
        ResourceModel model = this.createModel(operation, (PlaceholderResolverFactory)placeholderResolverFactory, context);
        Closeable closeable = new StandardWriterResolver((PlaceholderResolverFactory)placeholderResolverFactory, Charsets.UTF_8.name(), (TemplateFormat)JsonTemplateFormat.INSTANCE).resolve(operation.getName(), "resource", context);
        Throwable throwable = null;
        try {
            Writer it = (Writer)closeable;
            boolean bl = false;
            Writer writer = it.append(this.objectMapper.writeValueAsString((Object)model));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ResourceModel createModel(Operation operation, PlaceholderResolverFactory placeholderResolverFactory, RestDocumentationContext context) {
        List list;
        String string;
        List list2;
        Iterable $this$filter$iv;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        String string2;
        String string3;
        String string4;
        String string5;
        Set tags2;
        String operationId = this.propertyPlaceholderHelper.replacePlaceholders(operation.getName(), placeholderResolverFactory.create(context));
        String string6 = operation.getRequest().getContentAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"operation.request.contentAsString");
        boolean hasRequestBody = ((CharSequence)string6).length() > 0;
        String string7 = operation.getResponse().getContentAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"operation.response.contentAsString");
        boolean hasResponseBody = ((CharSequence)string7).length() > 0;
        SecurityRequirements securityRequirements = new SecurityRequirementsHandler().extractSecurityRequirements(operation);
        if (this.resourceSnippetParameters.getTags().isEmpty()) {
            List list3 = this.getUriComponents(operation).getPathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getUriComponents(operation).pathSegments");
            v3 = Optional.ofNullable(CollectionsKt.firstOrNull((List)list3)).map(arg_0 -> ResourceSnippet.createModel$lambda$1(createModel.tags.1.INSTANCE, arg_0)).orElse(SetsKt.emptySet());
        } else {
            v3 = tags2 = this.resourceSnippetParameters.getTags();
        }
        if ((string5 = this.resourceSnippetParameters.getSummary()) == null) {
            string5 = string4 = this.resourceSnippetParameters.getDescription();
        }
        if ((string3 = this.resourceSnippetParameters.getDescription()) == null) {
            string3 = this.resourceSnippetParameters.getSummary();
        }
        String string8 = string3;
        boolean bl = this.resourceSnippetParameters.getPrivateResource();
        boolean bl2 = this.resourceSnippetParameters.getDeprecated();
        Object object = this.getUriPath(operation);
        String string9 = operation.getRequest().getMethod().name();
        if (hasRequestBody) {
            HttpHeaders httpHeaders = operation.getRequest().getHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"operation.request.headers");
            string2 = this.getContentTypeOrDefault(httpHeaders);
        } else {
            string2 = null;
        }
        String string10 = string2;
        List<HeaderDescriptorWithType> list4 = this.resourceSnippetParameters.getRequestHeaders();
        HttpHeaders httpHeaders = operation.getRequest().getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"operation.request.headers");
        List<HeaderDescriptorWithType> list5 = this.withExampleValues(list4, httpHeaders);
        Iterable $this$filter$iv2 = this.resourceSnippetParameters.getPathParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            ParameterDescriptorWithType it = (ParameterDescriptorWithType)((Object)element$iv$iv);
            boolean bl3 = false;
            if (!(!it.isIgnored())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object2 = (List)destination$iv$iv;
        Iterable $this$filter$iv3 = this.resourceSnippetParameters.getQueryParameters();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv3;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ParameterDescriptorWithType it = (ParameterDescriptorWithType)((Object)element$iv$iv);
            boolean bl4 = false;
            if (!(!it.isIgnored())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List list6 = (List)destination$iv$iv2;
        Object $this$filter$iv4 = this.resourceSnippetParameters.getFormParameters();
        boolean $i$f$filter222 = false;
        destination$iv$iv2 = $this$filter$iv4;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo32 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ParameterDescriptorWithType it = (ParameterDescriptorWithType)((Object)element$iv$iv);
            boolean bl5 = false;
            if (!(!it.isIgnored())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv3 = (List)destination$iv$iv3;
        $this$filter$iv4 = this.resourceSnippetParameters.getRequestSchema();
        if (hasRequestBody) {
            void $this$filterTo$iv$iv4;
            $this$filter$iv = this.resourceSnippetParameters.getRequestFields();
            boolean $i$f$filter3 = false;
            Iterable $i$f$filterTo32 = $this$filter$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo4 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv4) {
                FieldDescriptor it = (FieldDescriptor)element$iv$iv;
                boolean bl6 = false;
                if (!(!it.isIgnored())) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv4;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $i$f$filter222 = list2;
        $this$filter$iv = hasRequestBody ? operation.getRequest().getContentAsString() : null;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getUriPath(operation)");
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"name()");
        RequestModel requestModel = new RequestModel((String)object, string9, string10, (Schema)$this$filter$iv4, list5, (List<ParameterDescriptorWithType>)object2, list6, (List<ParameterDescriptorWithType>)$this$filter$iv3, (List<? extends FieldDescriptor>)$i$f$filter222, (String)((Object)$this$filter$iv), securityRequirements);
        int n = operation.getResponse().getStatus().value();
        if (hasResponseBody) {
            HttpHeaders httpHeaders2 = operation.getResponse().getHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders2, (String)"operation.response.headers");
            string = this.getContentTypeOrDefault(httpHeaders2);
        } else {
            string = null;
        }
        string10 = string;
        List<HeaderDescriptorWithType> list7 = this.resourceSnippetParameters.getResponseHeaders();
        HttpHeaders httpHeaders3 = operation.getResponse().getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders3, (String)"operation.response.headers");
        list5 = this.withExampleValues(list7, httpHeaders3);
        object2 = this.resourceSnippetParameters.getResponseSchema();
        if (hasResponseBody) {
            void $this$filterTo$iv$iv5;
            $this$filter$iv3 = this.resourceSnippetParameters.getResponseFields();
            $i$f$filter = false;
            $i$f$filter222 = $this$filter$iv3;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv5) {
                FieldDescriptor it = (FieldDescriptor)element$iv$iv;
                boolean bl7 = false;
                if (!(!it.isIgnored())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        list6 = list;
        String string11 = hasResponseBody ? operation.getResponse().getContentAsString() : null;
        object = new ResponseModel(n, string10, (Schema)object2, list5, list6, string11);
        Intrinsics.checkNotNullExpressionValue((Object)operationId, (String)"operationId");
        Intrinsics.checkNotNullExpressionValue((Object)tags2, (String)"tags");
        return new ResourceModel(operationId, string4, string8, bl, bl2, requestModel, (ResponseModel)object, tags2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<HeaderDescriptorWithType> withExampleValues(List<HeaderDescriptorWithType> $this$withExampleValues, HttpHeaders headers) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$withExampleValues;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HeaderDescriptorWithType headerDescriptorWithType = (HeaderDescriptorWithType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.withExample((HeaderDescriptorWithType)it, headers));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return $this$withExampleValues;
    }

    private final HeaderDescriptorWithType withExample(HeaderDescriptorWithType $this$withExample, HttpHeaders headers) {
        block0: {
            String string;
            String string2 = headers.getFirst($this$withExample.getName());
            if (string2 == null) break block0;
            String it = string = string2;
            boolean bl = false;
            $this$withExample.setExample(it);
        }
        return $this$withExample;
    }

    private final UriComponents getUriComponents(Operation operation) {
        Object v = operation.getAttributes().get("org.springframework.restdocs.urlTemplate");
        return Optional.ofNullable(v instanceof String ? (String)v : null).map(arg_0 -> ResourceSnippet.getUriComponents$lambda$9(getUriComponents.1.INSTANCE, arg_0)).orElseThrow(ResourceSnippet::getUriComponents$lambda$10);
    }

    private final String getUriPath(Operation operation) {
        return this.getUriComponents(operation).getPath();
    }

    private final String getContentTypeOrDefault(HttpHeaders headers) {
        String string = Optional.ofNullable(headers.getContentType()).map(arg_0 -> ResourceSnippet.getContentTypeOrDefault$lambda$11(getContentTypeOrDefault.1.INSTANCE, arg_0)).orElse(MediaType.APPLICATION_JSON).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ofNullable(headers.conte\u2026)\n            .toString()");
        return string;
    }

    private static final Set createModel$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final UriComponents getUriComponents$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (UriComponents)$tmp0.invoke(p0);
    }

    private static final MissingUrlTemplateException getUriComponents$lambda$10() {
        return new MissingUrlTemplateException();
    }

    private static final MediaType getContentTypeOrDefault$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MediaType)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/epages/restdocs/apispec/ResourceSnippet$JsonTemplateFormat;", "Lorg/springframework/restdocs/templates/TemplateFormat;", "()V", "getFileExtension", "", "getId", "restdocs-api-spec"})
    public static final class JsonTemplateFormat
    implements TemplateFormat {
        @NotNull
        public static final JsonTemplateFormat INSTANCE = new JsonTemplateFormat();

        private JsonTemplateFormat() {
        }

        @NotNull
        public String getId() {
            return "json";
        }

        @NotNull
        public String getFileExtension() {
            return "json";
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u001a\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u00c6\u0003Jc\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lcom/epages/restdocs/apispec/ResourceSnippet$ResourceModel;", "", "operationId", "", "summary", "description", "privateResource", "", "deprecated", "request", "Lcom/epages/restdocs/apispec/ResourceSnippet$RequestModel;", "response", "Lcom/epages/restdocs/apispec/ResourceSnippet$ResponseModel;", "tags", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZLcom/epages/restdocs/apispec/ResourceSnippet$RequestModel;Lcom/epages/restdocs/apispec/ResourceSnippet$ResponseModel;Ljava/util/Set;)V", "getDeprecated", "()Z", "getDescription", "()Ljava/lang/String;", "getOperationId", "getPrivateResource", "getRequest", "()Lcom/epages/restdocs/apispec/ResourceSnippet$RequestModel;", "getResponse", "()Lcom/epages/restdocs/apispec/ResourceSnippet$ResponseModel;", "getSummary", "getTags", "()Ljava/util/Set;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "restdocs-api-spec"})
    private static final class ResourceModel {
        @NotNull
        private final String operationId;
        @Nullable
        private final String summary;
        @Nullable
        private final String description;
        private final boolean privateResource;
        private final boolean deprecated;
        @NotNull
        private final RequestModel request;
        @NotNull
        private final ResponseModel response;
        @NotNull
        private final Set<String> tags;

        public ResourceModel(@NotNull String operationId, @Nullable String summary, @Nullable String description, boolean privateResource, boolean deprecated, @NotNull RequestModel request, @NotNull ResponseModel response, @NotNull Set<String> tags2) {
            Intrinsics.checkNotNullParameter((Object)operationId, (String)"operationId");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter(tags2, (String)"tags");
            this.operationId = operationId;
            this.summary = summary;
            this.description = description;
            this.privateResource = privateResource;
            this.deprecated = deprecated;
            this.request = request;
            this.response = response;
            this.tags = tags2;
        }

        @NotNull
        public final String getOperationId() {
            return this.operationId;
        }

        @Nullable
        public final String getSummary() {
            return this.summary;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final boolean getPrivateResource() {
            return this.privateResource;
        }

        public final boolean getDeprecated() {
            return this.deprecated;
        }

        @NotNull
        public final RequestModel getRequest() {
            return this.request;
        }

        @NotNull
        public final ResponseModel getResponse() {
            return this.response;
        }

        @NotNull
        public final Set<String> getTags() {
            return this.tags;
        }

        @NotNull
        public final String component1() {
            return this.operationId;
        }

        @Nullable
        public final String component2() {
            return this.summary;
        }

        @Nullable
        public final String component3() {
            return this.description;
        }

        public final boolean component4() {
            return this.privateResource;
        }

        public final boolean component5() {
            return this.deprecated;
        }

        @NotNull
        public final RequestModel component6() {
            return this.request;
        }

        @NotNull
        public final ResponseModel component7() {
            return this.response;
        }

        @NotNull
        public final Set<String> component8() {
            return this.tags;
        }

        @NotNull
        public final ResourceModel copy(@NotNull String operationId, @Nullable String summary, @Nullable String description, boolean privateResource, boolean deprecated, @NotNull RequestModel request, @NotNull ResponseModel response, @NotNull Set<String> tags2) {
            Intrinsics.checkNotNullParameter((Object)operationId, (String)"operationId");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter(tags2, (String)"tags");
            return new ResourceModel(operationId, summary, description, privateResource, deprecated, request, response, tags2);
        }

        public static /* synthetic */ ResourceModel copy$default(ResourceModel resourceModel, String string, String string2, String string3, boolean bl, boolean bl2, RequestModel requestModel, ResponseModel responseModel, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = resourceModel.operationId;
            }
            if ((n & 2) != 0) {
                string2 = resourceModel.summary;
            }
            if ((n & 4) != 0) {
                string3 = resourceModel.description;
            }
            if ((n & 8) != 0) {
                bl = resourceModel.privateResource;
            }
            if ((n & 0x10) != 0) {
                bl2 = resourceModel.deprecated;
            }
            if ((n & 0x20) != 0) {
                requestModel = resourceModel.request;
            }
            if ((n & 0x40) != 0) {
                responseModel = resourceModel.response;
            }
            if ((n & 0x80) != 0) {
                set = resourceModel.tags;
            }
            return resourceModel.copy(string, string2, string3, bl, bl2, requestModel, responseModel, set);
        }

        @NotNull
        public String toString() {
            return "ResourceModel(operationId=" + this.operationId + ", summary=" + this.summary + ", description=" + this.description + ", privateResource=" + this.privateResource + ", deprecated=" + this.deprecated + ", request=" + this.request + ", response=" + this.response + ", tags=" + this.tags + ")";
        }

        public int hashCode() {
            int result = this.operationId.hashCode();
            result = result * 31 + (this.summary == null ? 0 : this.summary.hashCode());
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            int n = this.privateResource ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.deprecated ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            result = result * 31 + this.request.hashCode();
            result = result * 31 + this.response.hashCode();
            result = result * 31 + ((Object)this.tags).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResourceModel)) {
                return false;
            }
            ResourceModel resourceModel = (ResourceModel)other;
            if (!Intrinsics.areEqual((Object)this.operationId, (Object)resourceModel.operationId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.summary, (Object)resourceModel.summary)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)resourceModel.description)) {
                return false;
            }
            if (this.privateResource != resourceModel.privateResource) {
                return false;
            }
            if (this.deprecated != resourceModel.deprecated) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.request, (Object)resourceModel.request)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.response, (Object)resourceModel.response)) {
                return false;
            }
            return Intrinsics.areEqual(this.tags, resourceModel.tags);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100\tH\u00c6\u0003J\u009d\u0001\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00c6\u0001J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00103\u001a\u000204H\u00d6\u0001J\t\u00105\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00066"}, d2={"Lcom/epages/restdocs/apispec/ResourceSnippet$RequestModel;", "", "path", "", "method", "contentType", "schema", "Lcom/epages/restdocs/apispec/Schema;", "headers", "", "Lcom/epages/restdocs/apispec/HeaderDescriptorWithType;", "pathParameters", "Lcom/epages/restdocs/apispec/ParameterDescriptorWithType;", "queryParameters", "formParameters", "requestFields", "Lorg/springframework/restdocs/payload/FieldDescriptor;", "example", "securityRequirements", "Lcom/epages/restdocs/apispec/SecurityRequirements;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/epages/restdocs/apispec/Schema;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Lcom/epages/restdocs/apispec/SecurityRequirements;)V", "getContentType", "()Ljava/lang/String;", "getExample", "getFormParameters", "()Ljava/util/List;", "getHeaders", "getMethod", "getPath", "getPathParameters", "getQueryParameters", "getRequestFields", "getSchema", "()Lcom/epages/restdocs/apispec/Schema;", "getSecurityRequirements", "()Lcom/epages/restdocs/apispec/SecurityRequirements;", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "restdocs-api-spec"})
    private static final class RequestModel {
        @NotNull
        private final String path;
        @NotNull
        private final String method;
        @Nullable
        private final String contentType;
        @Nullable
        private final Schema schema;
        @NotNull
        private final List<HeaderDescriptorWithType> headers;
        @NotNull
        private final List<ParameterDescriptorWithType> pathParameters;
        @NotNull
        private final List<ParameterDescriptorWithType> queryParameters;
        @NotNull
        private final List<ParameterDescriptorWithType> formParameters;
        @NotNull
        private final List<FieldDescriptor> requestFields;
        @Nullable
        private final String example;
        @Nullable
        private final SecurityRequirements securityRequirements;

        public RequestModel(@NotNull String path, @NotNull String method, @Nullable String contentType, @Nullable Schema schema, @NotNull List<HeaderDescriptorWithType> headers, @NotNull List<ParameterDescriptorWithType> pathParameters, @NotNull List<ParameterDescriptorWithType> queryParameters, @NotNull List<ParameterDescriptorWithType> formParameters, @NotNull List<? extends FieldDescriptor> requestFields, @Nullable String example, @Nullable SecurityRequirements securityRequirements) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter(pathParameters, (String)"pathParameters");
            Intrinsics.checkNotNullParameter(queryParameters, (String)"queryParameters");
            Intrinsics.checkNotNullParameter(formParameters, (String)"formParameters");
            Intrinsics.checkNotNullParameter(requestFields, (String)"requestFields");
            this.path = path;
            this.method = method;
            this.contentType = contentType;
            this.schema = schema;
            this.headers = headers;
            this.pathParameters = pathParameters;
            this.queryParameters = queryParameters;
            this.formParameters = formParameters;
            this.requestFields = requestFields;
            this.example = example;
            this.securityRequirements = securityRequirements;
        }

        public /* synthetic */ RequestModel(String string, String string2, String string3, Schema schema, List list, List list2, List list3, List list4, List list5, String string4, SecurityRequirements securityRequirements, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                schema = null;
            }
            this(string, string2, string3, schema, list, list2, list3, list4, list5, string4, securityRequirements);
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @Nullable
        public final String getContentType() {
            return this.contentType;
        }

        @Nullable
        public final Schema getSchema() {
            return this.schema;
        }

        @NotNull
        public final List<HeaderDescriptorWithType> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final List<ParameterDescriptorWithType> getPathParameters() {
            return this.pathParameters;
        }

        @NotNull
        public final List<ParameterDescriptorWithType> getQueryParameters() {
            return this.queryParameters;
        }

        @NotNull
        public final List<ParameterDescriptorWithType> getFormParameters() {
            return this.formParameters;
        }

        @NotNull
        public final List<FieldDescriptor> getRequestFields() {
            return this.requestFields;
        }

        @Nullable
        public final String getExample() {
            return this.example;
        }

        @Nullable
        public final SecurityRequirements getSecurityRequirements() {
            return this.securityRequirements;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.method;
        }

        @Nullable
        public final String component3() {
            return this.contentType;
        }

        @Nullable
        public final Schema component4() {
            return this.schema;
        }

        @NotNull
        public final List<HeaderDescriptorWithType> component5() {
            return this.headers;
        }

        @NotNull
        public final List<ParameterDescriptorWithType> component6() {
            return this.pathParameters;
        }

        @NotNull
        public final List<ParameterDescriptorWithType> component7() {
            return this.queryParameters;
        }

        @NotNull
        public final List<ParameterDescriptorWithType> component8() {
            return this.formParameters;
        }

        @NotNull
        public final List<FieldDescriptor> component9() {
            return this.requestFields;
        }

        @Nullable
        public final String component10() {
            return this.example;
        }

        @Nullable
        public final SecurityRequirements component11() {
            return this.securityRequirements;
        }

        @NotNull
        public final RequestModel copy(@NotNull String path, @NotNull String method, @Nullable String contentType, @Nullable Schema schema, @NotNull List<HeaderDescriptorWithType> headers, @NotNull List<ParameterDescriptorWithType> pathParameters, @NotNull List<ParameterDescriptorWithType> queryParameters, @NotNull List<ParameterDescriptorWithType> formParameters, @NotNull List<? extends FieldDescriptor> requestFields, @Nullable String example, @Nullable SecurityRequirements securityRequirements) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter(pathParameters, (String)"pathParameters");
            Intrinsics.checkNotNullParameter(queryParameters, (String)"queryParameters");
            Intrinsics.checkNotNullParameter(formParameters, (String)"formParameters");
            Intrinsics.checkNotNullParameter(requestFields, (String)"requestFields");
            return new RequestModel(path, method, contentType, schema, headers, pathParameters, queryParameters, formParameters, requestFields, example, securityRequirements);
        }

        public static /* synthetic */ RequestModel copy$default(RequestModel requestModel, String string, String string2, String string3, Schema schema, List list, List list2, List list3, List list4, List list5, String string4, SecurityRequirements securityRequirements, int n, Object object) {
            if ((n & 1) != 0) {
                string = requestModel.path;
            }
            if ((n & 2) != 0) {
                string2 = requestModel.method;
            }
            if ((n & 4) != 0) {
                string3 = requestModel.contentType;
            }
            if ((n & 8) != 0) {
                schema = requestModel.schema;
            }
            if ((n & 0x10) != 0) {
                list = requestModel.headers;
            }
            if ((n & 0x20) != 0) {
                list2 = requestModel.pathParameters;
            }
            if ((n & 0x40) != 0) {
                list3 = requestModel.queryParameters;
            }
            if ((n & 0x80) != 0) {
                list4 = requestModel.formParameters;
            }
            if ((n & 0x100) != 0) {
                list5 = requestModel.requestFields;
            }
            if ((n & 0x200) != 0) {
                string4 = requestModel.example;
            }
            if ((n & 0x400) != 0) {
                securityRequirements = requestModel.securityRequirements;
            }
            return requestModel.copy(string, string2, string3, schema, list, list2, list3, list4, list5, string4, securityRequirements);
        }

        @NotNull
        public String toString() {
            return "RequestModel(path=" + this.path + ", method=" + this.method + ", contentType=" + this.contentType + ", schema=" + this.schema + ", headers=" + this.headers + ", pathParameters=" + this.pathParameters + ", queryParameters=" + this.queryParameters + ", formParameters=" + this.formParameters + ", requestFields=" + this.requestFields + ", example=" + this.example + ", securityRequirements=" + this.securityRequirements + ")";
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.method.hashCode();
            result = result * 31 + (this.contentType == null ? 0 : this.contentType.hashCode());
            result = result * 31 + (this.schema == null ? 0 : this.schema.hashCode());
            result = result * 31 + ((Object)this.headers).hashCode();
            result = result * 31 + ((Object)this.pathParameters).hashCode();
            result = result * 31 + ((Object)this.queryParameters).hashCode();
            result = result * 31 + ((Object)this.formParameters).hashCode();
            result = result * 31 + ((Object)this.requestFields).hashCode();
            result = result * 31 + (this.example == null ? 0 : this.example.hashCode());
            result = result * 31 + (this.securityRequirements == null ? 0 : this.securityRequirements.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RequestModel)) {
                return false;
            }
            RequestModel requestModel = (RequestModel)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)requestModel.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.method, (Object)requestModel.method)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.contentType, (Object)requestModel.contentType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.schema, (Object)requestModel.schema)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.headers, requestModel.headers)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.pathParameters, requestModel.pathParameters)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.queryParameters, requestModel.queryParameters)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.formParameters, requestModel.formParameters)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.requestFields, requestModel.requestFields)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.example, (Object)requestModel.example)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.securityRequirements, (Object)requestModel.securityRequirements);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003JW\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\t\u0010$\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/epages/restdocs/apispec/ResourceSnippet$ResponseModel;", "", "status", "", "contentType", "", "schema", "Lcom/epages/restdocs/apispec/Schema;", "headers", "", "Lcom/epages/restdocs/apispec/HeaderDescriptorWithType;", "responseFields", "Lorg/springframework/restdocs/payload/FieldDescriptor;", "example", "(ILjava/lang/String;Lcom/epages/restdocs/apispec/Schema;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getContentType", "()Ljava/lang/String;", "getExample", "getHeaders", "()Ljava/util/List;", "getResponseFields", "getSchema", "()Lcom/epages/restdocs/apispec/Schema;", "getStatus", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "restdocs-api-spec"})
    private static final class ResponseModel {
        private final int status;
        @Nullable
        private final String contentType;
        @Nullable
        private final Schema schema;
        @NotNull
        private final List<HeaderDescriptorWithType> headers;
        @NotNull
        private final List<FieldDescriptor> responseFields;
        @Nullable
        private final String example;

        public ResponseModel(int status, @Nullable String contentType, @Nullable Schema schema, @NotNull List<HeaderDescriptorWithType> headers, @NotNull List<? extends FieldDescriptor> responseFields, @Nullable String example) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter(responseFields, (String)"responseFields");
            this.status = status;
            this.contentType = contentType;
            this.schema = schema;
            this.headers = headers;
            this.responseFields = responseFields;
            this.example = example;
        }

        public /* synthetic */ ResponseModel(int n, String string, Schema schema, List list, List list2, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                schema = null;
            }
            this(n, string, schema, list, list2, string2);
        }

        public final int getStatus() {
            return this.status;
        }

        @Nullable
        public final String getContentType() {
            return this.contentType;
        }

        @Nullable
        public final Schema getSchema() {
            return this.schema;
        }

        @NotNull
        public final List<HeaderDescriptorWithType> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final List<FieldDescriptor> getResponseFields() {
            return this.responseFields;
        }

        @Nullable
        public final String getExample() {
            return this.example;
        }

        public final int component1() {
            return this.status;
        }

        @Nullable
        public final String component2() {
            return this.contentType;
        }

        @Nullable
        public final Schema component3() {
            return this.schema;
        }

        @NotNull
        public final List<HeaderDescriptorWithType> component4() {
            return this.headers;
        }

        @NotNull
        public final List<FieldDescriptor> component5() {
            return this.responseFields;
        }

        @Nullable
        public final String component6() {
            return this.example;
        }

        @NotNull
        public final ResponseModel copy(int status, @Nullable String contentType, @Nullable Schema schema, @NotNull List<HeaderDescriptorWithType> headers, @NotNull List<? extends FieldDescriptor> responseFields, @Nullable String example) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter(responseFields, (String)"responseFields");
            return new ResponseModel(status, contentType, schema, headers, responseFields, example);
        }

        public static /* synthetic */ ResponseModel copy$default(ResponseModel responseModel, int n, String string, Schema schema, List list, List list2, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = responseModel.status;
            }
            if ((n2 & 2) != 0) {
                string = responseModel.contentType;
            }
            if ((n2 & 4) != 0) {
                schema = responseModel.schema;
            }
            if ((n2 & 8) != 0) {
                list = responseModel.headers;
            }
            if ((n2 & 0x10) != 0) {
                list2 = responseModel.responseFields;
            }
            if ((n2 & 0x20) != 0) {
                string2 = responseModel.example;
            }
            return responseModel.copy(n, string, schema, list, list2, string2);
        }

        @NotNull
        public String toString() {
            return "ResponseModel(status=" + this.status + ", contentType=" + this.contentType + ", schema=" + this.schema + ", headers=" + this.headers + ", responseFields=" + this.responseFields + ", example=" + this.example + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.status);
            result = result * 31 + (this.contentType == null ? 0 : this.contentType.hashCode());
            result = result * 31 + (this.schema == null ? 0 : this.schema.hashCode());
            result = result * 31 + ((Object)this.headers).hashCode();
            result = result * 31 + ((Object)this.responseFields).hashCode();
            result = result * 31 + (this.example == null ? 0 : this.example.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResponseModel)) {
                return false;
            }
            ResponseModel responseModel = (ResponseModel)other;
            if (this.status != responseModel.status) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.contentType, (Object)responseModel.contentType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.schema, (Object)responseModel.schema)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.headers, responseModel.headers)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.responseFields, responseModel.responseFields)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.example, (Object)responseModel.example);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/epages/restdocs/apispec/ResourceSnippet$MissingUrlTemplateException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "()V", "restdocs-api-spec"})
    public static final class MissingUrlTemplateException
    extends RuntimeException {
        public MissingUrlTemplateException() {
            super("Missing URL template - please use RestDocumentationRequestBuilders with urlTemplate to construct the request");
        }
    }
}

