/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client.body.multipart;

import com.envimate.httpmate.client.body.Body;
import com.envimate.httpmate.client.body.multipart.MultipartRequestException;
import com.envimate.httpmate.client.body.multipart.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;

public final class MultipartBodyCreator {
    private static final String BOUNDARY = "abcdefggggg";
    private static final String CONTENT_TYPE = String.format("multipart/form-data; boundary=%s", "abcdefggggg");

    private MultipartBodyCreator() {
    }

    public static Body createMultipartBody(Part ... parts) {
        return Body.bodyWithContentType(() -> {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setBoundary(BOUNDARY);
            for (Part part : parts) {
                String controlName = part.controlName();
                String fileName = part.fileName().orElse(null);
                InputStream inputStream = part.fileContent();
                InputStreamBody body = new InputStreamBody(inputStream, fileName);
                FormBodyPart formBodyPart = new FormBodyPart(controlName, (ContentBody)body);
                multipartEntityBuilder.addPart(formBodyPart);
            }
            HttpEntity entity = multipartEntityBuilder.build();
            try {
                PipedInputStream inputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream(inputStream);
                new Thread(() -> {
                    try (PipedOutputStream outputStream = pipedOutputStream;){
                        entity.writeTo((OutputStream)outputStream);
                    }
                    catch (IOException e) {
                        throw MultipartRequestException.multipartRequestException(e);
                    }
                }).start();
                return inputStream;
            }
            catch (IOException e) {
                throw MultipartRequestException.multipartRequestException(e);
            }
        }, CONTENT_TYPE);
    }
}

