/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.util.describing.MapDumper;
import java.util.Map;

public final class SimpleHttpResponseObject {
    private final int statusCode;
    private final Map<String, String> headers;
    private final String body;

    public static SimpleHttpResponseObject httpClientResponse(int statusCode, Map<String, String> headers, String body) {
        return new SimpleHttpResponseObject(statusCode, headers, body);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public String describe() {
        Map<String, String> map = Map.of("Status Code", String.valueOf(this.statusCode), "Headers", this.headers, "Body", this.body);
        return MapDumper.describe((String)"HTTP Response", map);
    }

    public String toString() {
        return "SimpleHttpResponseObject(statusCode=" + this.getStatusCode() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleHttpResponseObject)) {
            return false;
        }
        SimpleHttpResponseObject other = (SimpleHttpResponseObject)o;
        if (this.getStatusCode() != other.getStatusCode()) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatusCode();
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    private SimpleHttpResponseObject(int statusCode, Map<String, String> headers, String body) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
    }
}

