/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.client.QueryParameter;
import com.envimate.httpmate.client.UriString;
import com.envimate.httpmate.util.Validators;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RequestPath {
    private final List<UriString> pathElements;
    private final List<QueryParameter> queryParameters;
    private final boolean trailingSlash;

    public static RequestPath parse(String raw) {
        List<QueryParameter> queryParameters;
        String rawPath;
        Validators.validateNotNull((Object)raw, (String)"raw");
        if (!raw.contains("?")) {
            rawPath = raw;
            queryParameters = new LinkedList<QueryParameter>();
        } else {
            int splitPosition = raw.indexOf(63);
            rawPath = raw.substring(0, splitPosition);
            String queryString = raw.substring(splitPosition + 1);
            String[] keyValues = queryString.split("&");
            queryParameters = Stream.of(keyValues).map(QueryParameter::parse).collect(Collectors.toList());
        }
        List<UriString> pathElements = Stream.of(rawPath.split("/")).filter(string -> !string.isEmpty()).map(UriString::uriString).collect(Collectors.toList());
        boolean trailingSlash = rawPath.endsWith("/");
        return new RequestPath(pathElements, queryParameters, trailingSlash);
    }

    public void add(QueryParameter queryParameter) {
        Validators.validateNotNull((Object)queryParameter, (String)"queryParameter");
        this.queryParameters.add(queryParameter);
    }

    public String render() {
        String path = this.path();
        String queryString = this.queryParameters.isEmpty() ? "" : this.queryParameters.stream().map(QueryParameter::render).collect(Collectors.joining("&", "?", ""));
        return path + queryString;
    }

    public String path() {
        String suffix = this.trailingSlash ? "/" : "";
        return this.pathElements.stream().map(UriString::encoded).collect(Collectors.joining("/", "/", suffix));
    }

    public List<QueryParameter> queryParameters() {
        return new ArrayList<QueryParameter>(this.queryParameters);
    }

    public String toString() {
        return "RequestPath(pathElements=" + this.pathElements + ", queryParameters=" + this.queryParameters + ", trailingSlash=" + this.trailingSlash + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestPath)) {
            return false;
        }
        RequestPath other = (RequestPath)o;
        List<UriString> this$pathElements = this.pathElements;
        List<UriString> other$pathElements = other.pathElements;
        if (this$pathElements == null ? other$pathElements != null : !((Object)this$pathElements).equals(other$pathElements)) {
            return false;
        }
        List<QueryParameter> this$queryParameters = this.queryParameters;
        List<QueryParameter> other$queryParameters = other.queryParameters;
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        return this.trailingSlash == other.trailingSlash;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UriString> $pathElements = this.pathElements;
        result = result * 59 + ($pathElements == null ? 43 : ((Object)$pathElements).hashCode());
        List<QueryParameter> $queryParameters = this.queryParameters;
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        result = result * 59 + (this.trailingSlash ? 79 : 97);
        return result;
    }

    private RequestPath(List<UriString> pathElements, List<QueryParameter> queryParameters, boolean trailingSlash) {
        this.pathElements = pathElements;
        this.queryParameters = queryParameters;
        this.trailingSlash = trailingSlash;
    }
}

