/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.util.Validators;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public final class BasePath {
    private final List<String> elements;

    static BasePath basePath(String basePath) {
        Validators.validateNotNull((Object)basePath, (String)"basePath");
        List<String> basePathElements = BasePath.splitPath(basePath);
        return new BasePath(basePathElements);
    }

    public String concatenateWithStartingAndTrailingSlash(String subPath) {
        StringJoiner pathJoiner = new StringJoiner("/", "/", "");
        this.elements.forEach(pathJoiner::add);
        List<String> subElements = BasePath.splitPath(subPath);
        subElements.forEach(pathJoiner::add);
        return pathJoiner.toString();
    }

    private static List<String> splitPath(String path) {
        return Arrays.stream(path.split("/")).filter(element -> !element.isEmpty()).collect(Collectors.toList());
    }

    public String toString() {
        return "BasePath(elements=" + this.elements + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePath)) {
            return false;
        }
        BasePath other = (BasePath)o;
        List<String> this$elements = this.elements;
        List<String> other$elements = other.elements;
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $elements = this.elements;
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    private BasePath(List<String> elements) {
        this.elements = elements;
    }
}

