/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client.issuer.real;

import com.envimate.httpmate.client.issuer.real.ConnectionFactory;
import com.envimate.httpmate.client.issuer.real.ConnectionFromPool;
import com.envimate.httpmate.client.issuer.real.Endpoint;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.http.HttpHost;
import org.apache.http.impl.pool.BasicConnPool;
import org.apache.http.impl.pool.BasicPoolEntry;

final class PooledConnectionFactory
implements ConnectionFactory {
    private static final int MAX_CONNECTIONS = 200;
    private static final int MAX_CONNECTIONS_PER_ROUTE = 10;
    private final BasicConnPool connectionPool;

    static ConnectionFactory pooledConnectionFactory() {
        BasicConnPool connectionPool = new BasicConnPool();
        connectionPool.setMaxTotal(200);
        connectionPool.setDefaultMaxPerRoute(10);
        return new PooledConnectionFactory(connectionPool);
    }

    @Override
    public ConnectionFromPool getConnectionTo(Endpoint endpoint) {
        HttpHost target = new HttpHost(endpoint.host(), endpoint.port(), endpoint.protocol().identifier());
        Future future = this.connectionPool.lease((Object)target, null);
        try {
            BasicPoolEntry entry = (BasicPoolEntry)future.get();
            return ConnectionFromPool.connectionFromPool(this.connectionPool, entry);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("This should never happen");
        }
    }

    private PooledConnectionFactory(BasicConnPool connectionPool) {
        this.connectionPool = connectionPool;
    }
}

