/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.client.HeaderKey;
import com.envimate.httpmate.client.HeaderValue;
import com.envimate.httpmate.client.HttpClientRequest;
import com.envimate.httpmate.client.QueryParameterKey;
import com.envimate.httpmate.client.QueryParameterValue;
import com.envimate.httpmate.client.requestbuilder.Body;
import com.envimate.httpmate.client.requestbuilder.BodyStage;
import com.envimate.httpmate.client.requestbuilder.HeadersAndQueryParametersAndMappingStage;
import com.envimate.httpmate.client.requestbuilder.PathStage;
import java.util.HashMap;
import java.util.Map;

public final class HttpClientRequestBuilder
implements PathStage,
BodyStage,
HeadersAndQueryParametersAndMappingStage {
    private final String method;
    private String path;
    private Body body;
    private final Map<HeaderKey, HeaderValue> headers = new HashMap<HeaderKey, HeaderValue>();
    private final Map<QueryParameterKey, QueryParameterValue> explicitQueryParameters = new HashMap<QueryParameterKey, QueryParameterValue>();

    public static PathStage httpClientRequestBuilderImplementation(String method) {
        return new HttpClientRequestBuilder(method);
    }

    @Override
    public BodyStage toThePath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public HeadersAndQueryParametersAndMappingStage withTheBody(Body body) {
        this.body = body;
        return this;
    }

    @Override
    public HeadersAndQueryParametersAndMappingStage withHeader(String key, String value) {
        HeaderKey headerKey = HeaderKey.headerKey(key);
        HeaderValue headerValue = HeaderValue.headerValue(value);
        this.headers.put(headerKey, headerValue);
        return this;
    }

    @Override
    public HeadersAndQueryParametersAndMappingStage withQueryParameter(String key, String value) {
        this.explicitQueryParameters.put(QueryParameterKey.queryParameterKey(key), QueryParameterValue.queryParameterValue(value));
        return this;
    }

    @Override
    public <T> HttpClientRequest<T> mappedTo(Class<T> targetType) {
        return HttpClientRequest.httpClientRequest(this.path, this.method, this.headers, this.explicitQueryParameters, this.body, targetType);
    }

    private HttpClientRequestBuilder(String method) {
        this.method = method;
    }
}

