/*
 * Decompiled with CFR 0.152.
 */
package com.emc.rest.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamUtil {
    private static final Logger log = LoggerFactory.getLogger(StreamUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        try {
            String string = new Scanner(inputStream, "UTF-8").useDelimiter("\\A").next();
            return string;
        }
        catch (NoSuchElementException e) {
            String string = "";
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable t) {
                log.warn("could not close stream", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream is, OutputStream os, long maxBytes) throws IOException {
        long count;
        byte[] buffer = new byte[65536];
        try {
            int read;
            for (count = 0L; count < maxBytes; count += (long)read) {
                int maxRead = (int)Math.min((long)buffer.length, maxBytes - count);
                read = is.read(buffer, 0, maxRead);
                if (-1 == read) {
                    break;
                }
                os.write(buffer, 0, read);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable t) {
                log.warn("could not close stream", t);
            }
            try {
                os.close();
            }
            catch (Throwable t) {
                log.warn("could not close stream", t);
            }
        }
        return count;
    }

    private StreamUtil() {
    }
}

