/*
 * Decompiled with CFR 0.152.
 */
package com.emc.rest.smart.ecs;

import com.emc.rest.smart.Host;
import com.emc.rest.smart.ecs.VdcHost;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Vdc
implements Iterable<VdcHost> {
    private String name;
    private List<VdcHost> hosts;

    public Vdc(String ... hostNames) {
        this.name = hostNames[0];
        this.hosts = new ArrayList<VdcHost>();
        for (String hostName : hostNames) {
            this.hosts.add(new VdcHost(this, hostName));
        }
    }

    public Vdc(List<? extends Host> hosts) {
        this(hosts.get(0).getName(), hosts);
    }

    public Vdc(String name, List<? extends Host> hosts) {
        this.name = name;
        this.hosts = this.createVdcHosts(hosts);
    }

    @Override
    public Iterator<VdcHost> iterator() {
        return this.hosts.iterator();
    }

    public boolean isHealthy() {
        for (Host host : this.hosts) {
            if (host.isHealthy()) continue;
            return false;
        }
        return true;
    }

    protected List<VdcHost> createVdcHosts(List<? extends Host> hosts) {
        ArrayList<VdcHost> vdcHosts = new ArrayList<VdcHost>();
        for (Host host : hosts) {
            vdcHosts.add(new VdcHost(this, host.getName()));
        }
        return vdcHosts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vdc)) {
            return false;
        }
        Vdc vdc = (Vdc)o;
        return this.getName().equals(vdc.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        String hostsString = "";
        if (this.hosts != null) {
            for (Host host : this.hosts) {
                if (hostsString.length() > 0) {
                    hostsString = hostsString + ",";
                }
                hostsString = hostsString + host.getName();
            }
        }
        return this.name + '(' + hostsString + ')';
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<VdcHost> getHosts() {
        return this.hosts;
    }

    public Vdc withName(String name) {
        this.setName(name);
        return this;
    }
}

