/*
 * Decompiled with CFR 0.152.
 */
package com.emc.rest.smart.ecs;

import com.emc.rest.smart.Host;
import com.emc.rest.smart.HostListProvider;
import com.emc.rest.smart.LoadBalancer;
import com.emc.rest.smart.ecs.ListDataNode;
import com.emc.rest.smart.ecs.PingItem;
import com.emc.rest.smart.ecs.PingResponse;
import com.emc.rest.smart.ecs.Vdc;
import com.emc.rest.smart.ecs.VdcHost;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcsHostListProvider
implements HostListProvider {
    private static final Logger log = LoggerFactory.getLogger(EcsHostListProvider.class);
    public static final String DEFAULT_PROTOCOL = "https";
    public static final int DEFAULT_PORT = 9021;
    protected final SimpleDateFormat rfc822DateFormat;
    private Client client;
    private LoadBalancer loadBalancer;
    private String user;
    private String secret;
    private String protocol = "https";
    private int port = 9021;
    private List<Vdc> vdcs;

    public EcsHostListProvider(Client client, LoadBalancer loadBalancer, String user, String secret) {
        this.client = client;
        this.loadBalancer = loadBalancer;
        this.user = user;
        this.secret = secret;
        this.rfc822DateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        this.rfc822DateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }

    @Override
    public List<Host> getHostList() {
        if (this.vdcs == null || this.vdcs.isEmpty()) {
            return this.getDataNodes(this.loadBalancer.getTopHost(null));
        }
        ArrayList<Host> hostList = new ArrayList<Host>();
        for (Vdc vdc : this.vdcs) {
            if (vdc.getHosts().isEmpty()) {
                log.warn("VDC " + vdc.getName() + " has no hosts!");
            }
            boolean success = false;
            for (Host host : vdc) {
                if (!host.isHealthy()) {
                    log.warn("not retrieving node list from " + host.getName() + " because it's unhealthy");
                    continue;
                }
                try {
                    this.updateVdcNodes(vdc, this.getDataNodes(host));
                    success = true;
                    break;
                }
                catch (Throwable t) {
                    log.warn("unable to retrieve node list from " + host.getName(), t);
                }
            }
            if (!success) {
                log.warn("could not retrieve node list for VDC " + vdc.getName());
            }
            hostList.addAll(vdc.getHosts());
        }
        return hostList;
    }

    @Override
    public void runHealthCheck(Host host) {
        PingResponse response = (PingResponse)this.client.resource(this.getRequestUri(host, "/?ping")).header("x-emc-namespace", (Object)"x").get(PingResponse.class);
        if (host instanceof VdcHost) {
            PingItem pingItem;
            PingItem.Status status = PingItem.Status.OFF;
            if (response != null && response.getPingItemMap() != null && (pingItem = response.getPingItemMap().get("MAINTENANCE_MODE")) != null) {
                status = pingItem.getStatus();
            }
            if (status == PingItem.Status.ON) {
                ((VdcHost)host).setMaintenanceMode(true);
            } else {
                ((VdcHost)host).setMaintenanceMode(false);
            }
        }
    }

    @Override
    public void destroy() {
        this.client.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Host> getDataNodes(Host host) {
        String signature;
        String rfcDate;
        String path = "/?endpoint";
        URI uri = this.getRequestUri(host, path);
        SimpleDateFormat simpleDateFormat = this.rfc822DateFormat;
        synchronized (simpleDateFormat) {
            rfcDate = this.rfc822DateFormat.format(new Date());
        }
        String canonicalString = "GET\n\n\n" + rfcDate + "\n" + path;
        try {
            signature = this.getSignature(canonicalString, this.secret);
        }
        catch (Exception e) {
            throw new RuntimeException("could not generate signature", e);
        }
        WebResource.Builder request = this.client.resource(uri).getRequestBuilder();
        request.header("Date", (Object)rfcDate);
        request.header("Authorization", (Object)("AWS " + this.user + ":" + signature));
        log.debug("retrieving VDC node list from {}", (Object)host.getName());
        List<String> dataNodes = ((ListDataNode)request.get(ListDataNode.class)).getDataNodes();
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (String node : dataNodes) {
            hosts.add(new Host(node));
        }
        return hosts;
    }

    protected URI getRequestUri(Host host, String path) {
        try {
            String portStr = this.port > -1 ? ":" + this.port : "";
            return new URI(this.protocol + "://" + host.getName() + portStr + path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getSignature(String canonicalString, String secret) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA1"));
        String signature = new String(Base64.encodeBase64((byte[])mac.doFinal(canonicalString.getBytes("UTF-8"))));
        log.debug("canonicalString:\n" + canonicalString);
        log.debug("signature:\n" + signature);
        return signature;
    }

    protected void updateVdcNodes(Vdc vdc, List<Host> nodeList) {
        if (nodeList == null || nodeList.isEmpty()) {
            throw new RuntimeException("node list is empty");
        }
        ArrayList<VdcHost> vdcNodeList = new ArrayList<VdcHost>();
        for (Host host : nodeList) {
            vdcNodeList.add(new VdcHost(vdc, host.getName()));
        }
        Iterator<VdcHost> vdcI = vdc.iterator();
        while (vdcI.hasNext()) {
            VdcHost vdcHost = vdcI.next();
            boolean hostPresent = false;
            Iterator nodeI = vdcNodeList.iterator();
            while (nodeI.hasNext()) {
                VdcHost node = (VdcHost)nodeI.next();
                if (!vdcHost.equals(node)) continue;
                hostPresent = true;
                nodeI.remove();
            }
            if (hostPresent) continue;
            log.info("host " + vdcHost.getName() + " was not in the updated node list; removing from VDC " + vdc.getName());
            vdcI.remove();
        }
        for (VdcHost node : vdcNodeList) {
            log.info("adding host " + node.getName() + " to VDC " + vdc.getName());
            vdc.getHosts().add(new VdcHost(vdc, node.getName()));
        }
    }

    public Client getClient() {
        return this.client;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public String getUser() {
        return this.user;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public List<Vdc> getVdcs() {
        return this.vdcs;
    }

    public void setVdcs(List<Vdc> vdcs) {
        this.vdcs = vdcs;
    }

    public EcsHostListProvider withVdcs(Vdc ... vdcs) {
        this.setVdcs(Arrays.asList(vdcs));
        return this;
    }
}

