/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression.lzma;

public class LzmaProfile {
    public static LzmaProfile[] LZMA_COMPRESSION_PROFILE = new LzmaProfile[]{new LzmaProfile(16384, 5, 0), new LzmaProfile(65536, 64, 0), new LzmaProfile(524288, 128, 0), new LzmaProfile(0x100000, 128, 0), new LzmaProfile(0x800000, 128, 0), new LzmaProfile(0x1000000, 128, 0), new LzmaProfile(0x1800000, 192, 0), new LzmaProfile(0x2000000, 224, 1), new LzmaProfile(0x3000000, 256, 1), new LzmaProfile(0x4000000, 273, 1)};
    int dictionarySize;
    int fastBytes;
    int matchFinder;
    int lc;
    int lp;
    int pb;

    public static LzmaProfile fromCompressionLevel(int compressionLevel) {
        return LZMA_COMPRESSION_PROFILE[compressionLevel];
    }

    public static long memoryRequiredForLzma(int compressionLevel) {
        return LzmaProfile.memoryRequiredForLzma(LZMA_COMPRESSION_PROFILE[compressionLevel]);
    }

    public static long memoryRequiredForLzma(LzmaProfile profile) {
        return (long)((double)profile.dictionarySize * 12.5);
    }

    public LzmaProfile(int dictionarySize, int fastBytes, int matchFinder) {
        this(dictionarySize, fastBytes, matchFinder, 3, 0, 2);
    }

    public LzmaProfile(int dictionarySize, int fastBytes, int matchFinder, int lc, int lp, int pb) {
        this.dictionarySize = dictionarySize;
        this.fastBytes = fastBytes;
        this.matchFinder = matchFinder;
        this.lc = lc;
        this.lp = lp;
        this.pb = pb;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public int getFastBytes() {
        return this.fastBytes;
    }

    public int getMatchFinder() {
        return this.matchFinder;
    }

    public int getLc() {
        return this.lc;
    }

    public int getLp() {
        return this.lp;
    }

    public int getPb() {
        return this.pb;
    }
}

