/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression.lzma;

import com.emc.codec.compression.CompressionException;
import com.emc.codec.compression.lzma.DecoderThread;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class LzmaDecodeOutputStream
extends FilterOutputStream {
    private OutputStream originalStream;
    private PipedOutputStream outputPipe;
    DecoderThread decoderThread;

    public LzmaDecodeOutputStream(OutputStream originalStream, int bufferSize) {
        super(originalStream);
        this.originalStream = originalStream;
        try {
            PipedInputStream inputPipe = new PipedInputStream(bufferSize);
            this.outputPipe = new PipedOutputStream(inputPipe);
            this.decoderThread = new DecoderThread(inputPipe, originalStream);
            this.decoderThread.start();
            this.out = this.outputPipe;
        }
        catch (IOException e) {
            throw new CompressionException("Could not create decompression stream", e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkForError();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkForError();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkForError();
        this.out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.decoderThread.join();
        }
        catch (InterruptedException e) {
            throw new CompressionException("interrupted while waiting for encoder thread", e);
        }
        this.originalStream.close();
        this.decoderThread = null;
    }

    protected void checkForError() {
        if (this.decoderThread != null && this.decoderThread.isErrorSet()) {
            Throwable t = this.decoderThread.getError();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new CompressionException("Compression error", t);
        }
    }
}

