/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec;

import com.emc.codec.EncodeListener;
import com.emc.codec.EncodeMetadata;
import com.emc.codec.EncodeStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class EncodeOutputStream<M extends EncodeMetadata>
extends FilterOutputStream
implements EncodeStream<M> {
    List<EncodeListener<M>> listeners = new ArrayList<EncodeListener<M>>();
    EncodeStream prevEncodeStream;
    EncodeStream nextEncodeStream;

    public EncodeOutputStream(OutputStream out) {
        super(out);
        if (out instanceof EncodeOutputStream) {
            ((EncodeOutputStream)out).prevEncodeStream = this;
            this.nextEncodeStream = (EncodeStream)((Object)out);
        }
    }

    protected void notifyListeners() {
        for (EncodeListener<M> listener : this.listeners) {
            listener.encodeComplete(this);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void addListener(EncodeListener<M> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(EncodeListener<M> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public EncodeStream getChainHead() {
        return this.prevEncodeStream == null ? this : this.prevEncodeStream.getChainHead();
    }

    @Override
    public EncodeStream getNext() {
        return this.nextEncodeStream;
    }
}

