/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec;

import com.emc.codec.AbstractCodec;
import com.emc.codec.EncodeInputStream;
import com.emc.codec.EncodeMetadata;
import com.emc.codec.EncodeOutputStream;
import com.emc.codec.EncodeStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class CodecChain {
    public static final String META_TRANSFORM_MODE = "x-emc-transform-mode";
    public static final String META_TRANSFORM_COMPLETE = "x-emc-transform-complete";
    private static ThreadLocal<ServiceLoader<AbstractCodec>> codecLoader = new ThreadLocal();
    private List<AbstractCodec> codecs;
    private Map<AbstractCodec, String> specMap = new HashMap<AbstractCodec, String>();
    private Map<String, Object> properties = new HashMap<String, Object>();

    private static ServiceLoader<AbstractCodec> getCodecLoader() {
        if (codecLoader.get() == null) {
            codecLoader.set(ServiceLoader.load(AbstractCodec.class));
        }
        return codecLoader.get();
    }

    public static String[] getEncodeSpecs(Map<String, String> metaMap) {
        if (metaMap == null) {
            return null;
        }
        String specString = metaMap.get(META_TRANSFORM_MODE);
        if (specString == null) {
            return null;
        }
        return specString.split(",");
    }

    public static void addEncodeSpec(Map<String, String> metaMap, String encodeSpec) {
        String specString = metaMap.get(META_TRANSFORM_MODE);
        if (specString != null && specString.length() > 0) {
            encodeSpec = specString + "," + encodeSpec;
        }
        metaMap.put(META_TRANSFORM_MODE, encodeSpec);
    }

    public static void removeEncodeSpec(Map<String, String> metaMap, String encodeSpec) {
        String specString = metaMap.get(META_TRANSFORM_MODE);
        if (specString.equals(encodeSpec)) {
            metaMap.remove(META_TRANSFORM_MODE);
        } else {
            if (!specString.endsWith("," + encodeSpec)) {
                throw new UnsupportedOperationException("the encode chain does not include " + encodeSpec);
            }
            metaMap.put(META_TRANSFORM_MODE, specString.substring(0, specString.length() - (encodeSpec.length() + 1)));
        }
    }

    public CodecChain(String ... encodeSpecs) {
        this.codecs = new ArrayList<AbstractCodec>();
        for (String encodeSpec : encodeSpecs) {
            boolean codecFound = false;
            for (AbstractCodec codec : CodecChain.getCodecLoader()) {
                if (!codec.canDecode(encodeSpec)) continue;
                codecFound = true;
                this.codecs.add(codec);
                this.specMap.put(codec, encodeSpec);
            }
            if (codecFound) continue;
            throw new IllegalArgumentException("Unsupported encoder: " + encodeSpec);
        }
    }

    public CodecChain(AbstractCodec ... codecs) {
        this(Arrays.asList(codecs), null);
    }

    public CodecChain(List<AbstractCodec> codecs, Map<String, Object> properties) {
        this.codecs = codecs;
        if (properties != null) {
            this.properties = properties;
        }
        Collections.sort(codecs);
    }

    public boolean isSizePredictable() {
        for (AbstractCodec codec : this.codecs) {
            if (codec.isSizePredictable()) continue;
            return false;
        }
        return true;
    }

    public long getEncodedSize(long originalSize) {
        long encodedSize = originalSize;
        for (AbstractCodec codec : this.codecs) {
            String encodeSpec = this.specMap.get(codec);
            encodedSize = encodeSpec == null ? codec.getEncodedSize(originalSize, this.properties) : codec.getEncodedSize(originalSize, encodeSpec, this.properties);
        }
        return encodedSize;
    }

    public OutputStream getEncodeStream(OutputStream targetStream, Map<String, String> completeMetaMap) {
        for (int i = this.codecs.size() - 1; i >= 0; --i) {
            AbstractCodec codec = this.codecs.get(i);
            String encodeSpec = this.specMap.get(codec);
            targetStream = encodeSpec == null ? codec.getEncodingStream(targetStream, this.properties) : codec.getEncodingStream(targetStream, encodeSpec, this.properties);
        }
        return new MetaAddingOutputStream(targetStream, completeMetaMap);
    }

    public InputStream getEncodeStream(InputStream sourceStream, Map<String, String> completeMetaMap) {
        for (AbstractCodec codec : this.codecs) {
            String encodeSpec = this.specMap.get(codec);
            if (encodeSpec == null) {
                sourceStream = codec.getEncodingStream(sourceStream, this.properties);
                continue;
            }
            sourceStream = codec.getEncodingStream(sourceStream, encodeSpec, this.properties);
        }
        return new MetaAddingInputStream(sourceStream, completeMetaMap);
    }

    public OutputStream getDecodeStream(OutputStream targetStream, Map<String, String> completeMetaMap) {
        List<EncodeMetadata> metadataList = this.getEncodeMetadataList(completeMetaMap);
        for (int i = 0; i < this.codecs.size(); ++i) {
            AbstractCodec codec = this.codecs.get(i);
            EncodeMetadata metadata = metadataList.get(i);
            targetStream = codec.getDecodingStream(targetStream, metadata, this.properties);
        }
        this.removeEncodeMetadata(completeMetaMap, metadataList);
        return targetStream;
    }

    public InputStream getDecodeStream(InputStream sourceStream, Map<String, String> completeMetaMap) {
        List<EncodeMetadata> metadataList = this.getEncodeMetadataList(completeMetaMap);
        for (int i = this.codecs.size() - 1; i >= 0; --i) {
            AbstractCodec codec = this.codecs.get(i);
            EncodeMetadata metadata = metadataList.get(i);
            sourceStream = codec.getDecodingStream(sourceStream, metadata, this.properties);
        }
        this.removeEncodeMetadata(completeMetaMap, metadataList);
        return sourceStream;
    }

    public List<EncodeMetadata> getEncodeMetadataList(Map<String, String> completeMetaMap) {
        Object[] encodeSpecs = CodecChain.getEncodeSpecs(completeMetaMap);
        ArrayList<EncodeMetadata> metadataList = new ArrayList<EncodeMetadata>();
        encodeSpecs = Arrays.copyOfRange(encodeSpecs, encodeSpecs.length - this.codecs.size(), encodeSpecs.length);
        for (int i = 0; i < this.codecs.size(); ++i) {
            String encodeSpec;
            AbstractCodec codec = this.codecs.get(i);
            if (!codec.canDecode(encodeSpec = encodeSpecs[i])) {
                throw new RuntimeException("this codec chain cannot decode the following encode list:\n" + Arrays.toString(encodeSpecs));
            }
            Object metadata = codec.createEncodeMetadata(encodeSpec, completeMetaMap);
            metadataList.add((EncodeMetadata)metadata);
        }
        return metadataList;
    }

    protected void addEncodeMetadata(Map<String, String> metaMap, EncodeStream encodeStream, boolean addEncodeSpec) {
        boolean complete = true;
        encodeStream = encodeStream.getChainHead();
        do {
            Object metadata;
            if (!((EncodeMetadata)(metadata = encodeStream.getEncodeMetadata())).isComplete()) {
                complete = false;
            }
            metaMap.putAll(((EncodeMetadata)metadata).toMap());
            if (!addEncodeSpec) continue;
            CodecChain.addEncodeSpec(metaMap, ((EncodeMetadata)metadata).getEncodeSpec());
        } while ((encodeStream = encodeStream.getNext()) != null);
        metaMap.put(META_TRANSFORM_COMPLETE, "" + complete);
    }

    public void removeEncodeMetadata(Map<String, String> metaMap, List<EncodeMetadata> encodeMetaList) {
        for (int i = encodeMetaList.size() - 1; i >= 0; --i) {
            EncodeMetadata metadata = encodeMetaList.get(i);
            CodecChain.removeEncodeSpec(metaMap, metadata.getEncodeSpec());
            metaMap.keySet().removeAll(metadata.toMap().keySet());
            metaMap.remove(META_TRANSFORM_COMPLETE);
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public CodecChain withProperties(Map<String, Object> properties) {
        this.setProperties(properties);
        return this;
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public CodecChain withProperty(String name, Object value) {
        this.addProperty(name, value);
        return this;
    }

    public class MetaAddingInputStream
    extends FilterInputStream {
        private EncodeInputStream lastInputStream;
        private Map<String, String> metaMap;

        public MetaAddingInputStream(EncodeInputStream lastInputStream, Map<String, String> metaMap) {
            super(lastInputStream);
            this.lastInputStream = lastInputStream;
            this.metaMap = metaMap;
            CodecChain.this.addEncodeMetadata(metaMap, lastInputStream, true);
        }

        @Override
        public void close() throws IOException {
            super.close();
            CodecChain.this.addEncodeMetadata(this.metaMap, this.lastInputStream, false);
        }
    }

    public class MetaAddingOutputStream
    extends FilterOutputStream {
        private EncodeOutputStream firstOutputStream;
        private Map<String, String> metaMap;

        public MetaAddingOutputStream(EncodeOutputStream firstOutputStream, Map<String, String> metaMap) {
            super(firstOutputStream);
            this.firstOutputStream = firstOutputStream;
            this.metaMap = metaMap;
            CodecChain.this.addEncodeMetadata(metaMap, firstOutputStream, true);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            super.close();
            CodecChain.this.addEncodeMetadata(this.metaMap, this.firstOutputStream, false);
        }
    }
}

